/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPOpenMessageParser;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.bgp.parser.spi.ParameterRegistry;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.OptionalCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapabilityBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

public class OpenTest {
    private final ParameterRegistry registry = ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow().getParameterRegistry();

    @Test
    public void testSerializeOpen() throws BGPDocumentedException {
        Open open = new OpenBuilder().setBgpIdentifier(new Ipv4AddressNoZone("127.0.0.1")).setMyAsNumber(Uint16.valueOf((int)30)).setHoldTimer(Uint16.valueOf((int)3)).setVersion(new ProtocolVersion(Uint8.valueOf((int)4))).setBgpParameters(List.of(new BgpParametersBuilder().setOptionalCapabilities(List.of(new OptionalCapabilitiesBuilder().setCParameters(new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)1000))).build()).addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf(false))).setRestartTime(Uint16.ZERO).setTables(Map.of()).build()).build()).build()).build())).build())).build();
        ByteBuf msg = Unpooled.buffer();
        new BGPOpenMessageParser(this.registry).serializeMessage((Notification)open, msg);
        byte[] temp = ByteArray.cutBytes((byte[])ByteArray.getAllBytes((ByteBuf)msg), (int)19);
        Open openResult = new BGPOpenMessageParser(this.registry).parseMessageBody(Unpooled.copiedBuffer((byte[])temp), temp.length, null);
        Assert.assertEquals((Object)open.getBgpIdentifier(), (Object)openResult.getBgpIdentifier());
        Assert.assertEquals((Object)open.getHoldTimer(), (Object)openResult.getHoldTimer());
        Assert.assertEquals((Object)open.getMyAsNumber(), (Object)openResult.getMyAsNumber());
        boolean grace = false;
        if (((OptionalCapabilities)((BgpParameters)openResult.getBgpParameters().get(0)).getOptionalCapabilities().get(0)).getCParameters().getAs4BytesCapability() != null) {
            grace = true;
        }
        Assert.assertEquals((Object)((OptionalCapabilities)((BgpParameters)open.getBgpParameters().get(0)).getOptionalCapabilities().get(0)).getCParameters().getAs4BytesCapability(), (Object)((OptionalCapabilities)((BgpParameters)openResult.getBgpParameters().get(0)).getOptionalCapabilities().get(grace ? 0 : 1)).getCParameters().getAs4BytesCapability());
        Assert.assertEquals((Object)((CParameters1)((OptionalCapabilities)((BgpParameters)open.getBgpParameters().get(0)).getOptionalCapabilities().get(0)).getCParameters().augmentation(CParameters1.class)).getGracefulRestartCapability(), (Object)((CParameters1)((OptionalCapabilities)((BgpParameters)openResult.getBgpParameters().get(0)).getOptionalCapabilities().get(grace ? 1 : 0)).getCParameters().augmentation(CParameters1.class)).getGracefulRestartCapability());
    }

    @Test
    public void testSerializeLongOpen() throws BGPDocumentedException {
        ArrayList<OptionalCapabilities> capabilities = new ArrayList<OptionalCapabilities>();
        for (int i = 0; i < 200; ++i) {
            capabilities.add(new OptionalCapabilitiesBuilder().setCParameters(new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)1000))).build()).build()).build());
        }
        Open open = new OpenBuilder().setBgpIdentifier(new Ipv4AddressNoZone("127.0.0.1")).setMyAsNumber(Uint16.valueOf((int)30)).setHoldTimer(Uint16.valueOf((int)3)).setVersion(new ProtocolVersion(Uint8.valueOf((int)4))).setBgpParameters(List.of(new BgpParametersBuilder().setOptionalCapabilities(capabilities).build())).build();
        ByteBuf msg = Unpooled.buffer();
        new BGPOpenMessageParser(this.registry).serializeMessage((Notification)open, msg);
        Assert.assertEquals((long)1235L, (long)msg.readableBytes());
        byte[] temp = ByteArray.cutBytes((byte[])ByteArray.getAllBytes((ByteBuf)msg), (int)19);
        Open openResult = new BGPOpenMessageParser(this.registry).parseMessageBody(Unpooled.copiedBuffer((byte[])temp), temp.length, null);
        Assert.assertEquals((long)200L, (long)((BgpParameters)openResult.getBgpParameters().get(0)).getOptionalCapabilities().size());
    }
}

