/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv6NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv6.next.hop._case.Ipv6NextHopBuilder;

public class NextHopAttributeParserTest {
    private static final byte[] IPV4_NEXT_HOP_BYTES = new byte[]{64, 3, 4, -1, -1, -1, -1};
    private static final byte[] IPV6_NEXT_HOP_BYTES = new byte[]{64, 3, 32, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
    private static final Attributes IPV4_RESULT = new AttributesBuilder().setCNextHop((CNextHop)new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4AddressNoZone("255.255.255.255")).build()).build()).build();
    private static final Attributes IPV6_RESULT = new AttributesBuilder().setCNextHop((CNextHop)new Ipv6NextHopCaseBuilder().setIpv6NextHop(new Ipv6NextHopBuilder().setGlobal(new Ipv6AddressNoZone("ffff::1")).setLinkLocal(new Ipv6AddressNoZone("ffff::2")).build()).build()).build();
    private final AttributeRegistry registry = ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow().getAttributeRegistry();

    @Test
    public void testIpv4AttributeParser() throws BGPParsingException, BGPDocumentedException {
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(IPV4_RESULT, actual);
        Assert.assertArrayEquals((byte[])IPV4_NEXT_HOP_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = this.registry.parseAttributes(actual, null).getAttributes();
        Assert.assertEquals((Object)IPV4_RESULT.getCNextHop(), (Object)attributeOut.getCNextHop());
    }

    @Test
    public void testIpv6AttributeParser() throws BGPParsingException, BGPDocumentedException {
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(IPV6_RESULT, actual);
        Assert.assertArrayEquals((byte[])IPV6_NEXT_HOP_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = this.registry.parseAttributes(actual, null).getAttributes();
        Assert.assertEquals((Object)IPV6_RESULT.getCNextHop(), (Object)attributeOut.getCNextHop());
    }

    @Test
    public void testParseEmptyIpv4Attribute() {
        NullPointerException ex = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.registry.serializeAttribute(new AttributesBuilder().setCNextHop((CNextHop)new Ipv4NextHopCaseBuilder().build()).build(), Unpooled.buffer()));
        Assert.assertNull((Object)ex.getMessage());
    }

    @Test
    public void testParseEmptyIpv6Attribute() {
        NullPointerException ex = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.registry.serializeAttribute(new AttributesBuilder().setCNextHop((CNextHop)new Ipv6NextHopCaseBuilder().build()).build(), Unpooled.buffer()));
        Assert.assertNull((Object)ex.getMessage());
    }
}

