/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributesBuilder;
import org.opendaylight.yangtools.yang.common.Uint8;

public class UnrecognizedAttributesSerializerTest {
    @Test
    public void testUnrecognizedAttributesSerializer() {
        byte[] unrecognizedValue1 = new byte[]{-45, 93, 53, -45, 93, 53, -45, 93, 53, -45, 93, 53};
        byte[] unrecognizedValue2 = new byte[]{-45, 93, 53, -45, 93, 53, -41, 93, 117, -41, 93, 117};
        byte[] unrecognizedBytes = new byte[]{-32, 101, 12, -45, 93, 53, -45, 93, 53, -45, 93, 53, -45, 93, 53, -32, 102, 12, -45, 93, 53, -45, 93, 53, -41, 93, 117, -41, 93, 117};
        UnrecognizedAttributes unrecognizedAttribute1 = new UnrecognizedAttributesBuilder().setPartial(Boolean.valueOf(true)).setTransitive(Boolean.valueOf(true)).setType(Uint8.valueOf((int)101)).setValue(unrecognizedValue1).build();
        UnrecognizedAttributes unrecognizedAttribute2 = new UnrecognizedAttributesBuilder().setPartial(Boolean.valueOf(true)).setTransitive(Boolean.valueOf(true)).setType(Uint8.valueOf((int)102)).setValue(unrecognizedValue2).build();
        Attributes attrs = new AttributesBuilder().setUnrecognizedAttributes((Map)ImmutableMap.of((Object)unrecognizedAttribute1.key(), (Object)unrecognizedAttribute1, (Object)unrecognizedAttribute2.key(), (Object)unrecognizedAttribute2)).build();
        ByteBuf buffer = Unpooled.buffer();
        ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow().getAttributeRegistry().serializeAttribute(attrs, buffer);
        Assert.assertArrayEquals((byte[])unrecognizedBytes, (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }
}

