/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.EncapsulationEC;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.EncapsulationTunnelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.EncapsulationCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.EncapsulationCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.LinkBandwidthCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.encapsulation._case.EncapsulationExtendedCommunityBuilder;

public class EncapsulationECTest {
    private static final byte[] RESULT = new byte[]{0, 0, 0, 0, 0, 10};
    private static final int COMMUNITY_VALUE_SIZE = 6;
    private static final EncapsulationTunnelType TUNNEL_TYPE = EncapsulationTunnelType.Mpls;
    private EncapsulationEC parser;

    @Before
    public void setUp() {
        this.parser = new EncapsulationEC();
    }

    @Test
    public void testParser() throws BGPParsingException, BGPDocumentedException {
        ByteBuf buffer = Unpooled.buffer((int)6);
        EncapsulationCase expected = new EncapsulationCaseBuilder().setEncapsulationExtendedCommunity(new EncapsulationExtendedCommunityBuilder().setTunnelType(TUNNEL_TYPE).build()).build();
        this.parser.serializeExtendedCommunity((ExtendedCommunity)expected, buffer);
        Assert.assertArrayEquals((byte[])RESULT, (byte[])ByteArray.getAllBytes((ByteBuf)buffer));
        ExtendedCommunity result = this.parser.parseExtendedCommunity(Unpooled.wrappedBuffer((byte[])RESULT));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongCase() {
        this.parser.serializeExtendedCommunity((ExtendedCommunity)new LinkBandwidthCaseBuilder().build(), null);
    }

    @Test
    public void testSubtype() {
        Assert.assertEquals((long)12L, (long)this.parser.getSubType());
    }
}

