/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.Ipv4SpecificEcHandler;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.Inet4SpecificExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.Inet4SpecificExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.inet4.specific.extended.community._case.Inet4SpecificExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommonBuilder;

public class Ipv4SpecificEcHandlerTest {
    private static final byte[] INPUT = new byte[]{12, 51, 2, 5, 21, 45};

    @Test
    public void testHandlerDeprecated() {
        Ipv4SpecificEcHandler handler = new Ipv4SpecificEcHandler();
        Inet4SpecificExtendedCommunityCase input = new Inet4SpecificExtendedCommunityCaseBuilder().setInet4SpecificExtendedCommunity(new Inet4SpecificExtendedCommunityBuilder().setGlobalAdministrator(new Ipv4AddressNoZone("12.51.2.5")).setLocalAdministrator(new byte[]{21, 45}).build()).build();
        Inet4SpecificExtendedCommunityCase expected = new Inet4SpecificExtendedCommunityCaseBuilder().setInet4SpecificExtendedCommunity(new Inet4SpecificExtendedCommunityBuilder().setInet4SpecificExtendedCommunityCommon(new Inet4SpecificExtendedCommunityCommonBuilder().setGlobalAdministrator(new Ipv4AddressNoZone("12.51.2.5")).setLocalAdministrator(new byte[]{21, 45}).build()).build()).build();
        ExtendedCommunity exComm = handler.parseExtendedCommunity(Unpooled.copiedBuffer((byte[])INPUT));
        Assert.assertEquals((Object)expected, (Object)exComm);
        ByteBuf output = Unpooled.buffer((int)INPUT.length);
        handler.serializeExtendedCommunity((ExtendedCommunity)input, output);
        Assert.assertArrayEquals((byte[])INPUT, (byte[])output.array());
    }

    @Test
    public void testHandle() {
        Ipv4SpecificEcHandler handler = new Ipv4SpecificEcHandler();
        Inet4SpecificExtendedCommunityCase expected = new Inet4SpecificExtendedCommunityCaseBuilder().setInet4SpecificExtendedCommunity(new Inet4SpecificExtendedCommunityBuilder().setInet4SpecificExtendedCommunityCommon(new Inet4SpecificExtendedCommunityCommonBuilder().setGlobalAdministrator(new Ipv4AddressNoZone("12.51.2.5")).setLocalAdministrator(new byte[]{21, 45}).build()).build()).build();
        ExtendedCommunity exComm = handler.parseExtendedCommunity(Unpooled.copiedBuffer((byte[])INPUT));
        Assert.assertEquals((Object)expected, (Object)exComm);
        ByteBuf output = Unpooled.buffer((int)INPUT.length);
        handler.serializeExtendedCommunity((ExtendedCommunity)expected, output);
        Assert.assertArrayEquals((byte[])INPUT, (byte[])output.array());
    }
}

