/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.LinkBandwidthEC;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.Inet4SpecificExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.LinkBandwidthCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.LinkBandwidthCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.link.bandwidth._case.LinkBandwidthExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;

public class LinkBandwidthECTest {
    private static final byte[] RESULT = new byte[]{91, -96, 0, 0, -1, -1};
    private static final int COMMUNITY_VALUE_SIZE = 6;
    private LinkBandwidthEC parser;

    @Before
    public void setUp() {
        this.parser = new LinkBandwidthEC();
    }

    @Test
    public void parserTest() throws BGPParsingException, BGPDocumentedException {
        ByteBuf buff = Unpooled.buffer((int)6);
        LinkBandwidthCase expected = new LinkBandwidthCaseBuilder().setLinkBandwidthExtendedCommunity(new LinkBandwidthExtendedCommunityBuilder().setBandwidth(new Bandwidth(new byte[]{0, 0, -1, -1})).build()).build();
        this.parser.serializeExtendedCommunity((ExtendedCommunity)expected, buff);
        Assert.assertArrayEquals((byte[])RESULT, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        ExtendedCommunity result = this.parser.parseExtendedCommunity(Unpooled.wrappedBuffer((byte[])RESULT));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void wrongCaseTest() {
        this.parser.serializeExtendedCommunity((ExtendedCommunity)new Inet4SpecificExtendedCommunityCaseBuilder().build(), null);
    }

    @Test
    public void testSubtype() {
        Assert.assertEquals((long)4L, (long)this.parser.getSubType());
    }
}

