/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.four.octect.as.specific.SourceAS4OctectHandler;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.As4GenericSpecExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAs4ExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAs4ExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.source.as._4.extended.community._case.SourceAs4ExtendedCommunityBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;

public class SourceAS4OctectASHandlerTest {
    private static final byte[] INPUT = new byte[]{0, 0, 0, 20, 0, 0};
    private final SourceAS4OctectHandler handler = new SourceAS4OctectHandler();

    @Test
    public void testHandler() {
        SourceAs4ExtendedCommunityCase expected = new SourceAs4ExtendedCommunityCaseBuilder().setSourceAs4ExtendedCommunity(new SourceAs4ExtendedCommunityBuilder().setGlobalAdministrator(new AsNumber(Uint32.valueOf((int)20))).build()).build();
        ExtendedCommunity exComm = this.handler.parseExtendedCommunity(Unpooled.copiedBuffer((byte[])INPUT));
        Assert.assertEquals((Object)expected, (Object)exComm);
        ByteBuf output = Unpooled.buffer((int)INPUT.length);
        this.handler.serializeExtendedCommunity((ExtendedCommunity)expected, output);
        Assert.assertArrayEquals((byte[])INPUT, (byte[])output.array());
        Assert.assertEquals((long)209L, (long)this.handler.getSubType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHandlerError() {
        this.handler.serializeExtendedCommunity((ExtendedCommunity)new As4GenericSpecExtendedCommunityCaseBuilder().build(), null);
    }
}

