/*
 * Copyright (c) 2013 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapabilityBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class As4CapabilityHandler implements CapabilityParser, CapabilitySerializer {
    public static final int CODE = 65;

    @Override
    public CParameters parseCapability(final ByteBuf buffer) {
        return new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder()
            .setAsNumber(new AsNumber(ByteBufUtils.readUint32(buffer))).build()).build();
    }

    @Override
    public void serializeCapability(final CParameters capability, final ByteBuf byteAggregator) {
        final As4BytesCapability as4 = capability.getAs4BytesCapability();
        if (as4 != null) {
            CapabilityUtil.formatCapability(CODE, putAS4BytesParameterValue(as4), byteAggregator);
        }
    }

    private static ByteBuf putAS4BytesParameterValue(final As4BytesCapability param) {
        return Unpooled.copyInt(param.getAsNumber().getValue().intValue());
    }
}
