/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPKeepAliveMessageParser;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPNotificationMessageParser;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPOpenMessageParser;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPRouteRefreshMessageParser;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPUpdateMessageParser;
import org.opendaylight.protocol.bgp.parser.impl.message.open.AddPathCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.open.As4CapabilityHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.open.BgpExtendedMessageCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.open.CapabilityParameterParser;
import org.opendaylight.protocol.bgp.parser.impl.message.open.GracefulCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.open.LlGracefulCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.open.MultiProtocolCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.open.RouteRefreshCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AS4AggregatorAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AS4PathAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AggregatorAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AigpAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AsPathAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AtomicAggregateAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.BgpPrefixSidAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.ClusterIdAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunitiesAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.ExtendedCommunitiesAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.LocalPreferenceAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.MPReachAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.MPUnreachAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.MultiExitDiscriminatorAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.NextHopAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.OriginAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.OriginatorIdAttributeParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.UnrecognizedAttributesSerializer;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.AsTwoOctetSpecificEcHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.EncapsulationEC;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.Ipv4SpecificEcHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.LinkBandwidthEC;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.OpaqueEcHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.RouteOriginAsTwoOctetEcHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.RouteOriginIpv4EcHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.SourceASHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.VrfRouteImportHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.four.octect.as.specific.Generic4OctASEcHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.four.octect.as.specific.RouteOrigin4OctectASEcHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.four.octect.as.specific.SourceAS4OctectHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.route.target.RouteTarget4OctectASEcHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.route.target.RouteTargetAsTwoOctetEcHandler;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.route.target.RouteTargetIpv4EcHandler;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderActivator;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityParser;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunitySerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Notify;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.BgpExtendedMessageCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aigp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.BgpPrefixSid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.RouteRefresh;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.reach.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.attributes.unreach.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.AddPathCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.RouteRefreshCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.MplsLabeledVpnSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.NextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.As4GenericSpecExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.As4RouteOriginExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.As4RouteTargetExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.AsSpecificExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.EncapsulationCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.Inet4SpecificExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.LinkBandwidthCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.OpaqueExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteOriginExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteOriginIpv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteTargetExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteTargetIpv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAs4ExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAsExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.VrfRouteImportExtendedCommunityCase;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Component;

@Singleton
@Component(immediate=true, property={"type=org.opendaylight.protocol.bgp.parser.impl.BGPActivator"})
public final class BGPActivator
implements BGPExtensionProviderActivator {
    private static final int IPV4_AFI = 1;
    private static final int IPV6_AFI = 2;
    private static final int UNICAST_SAFI = 1;
    private static final int VPN_SAFI = 128;

    @Inject
    public BGPActivator() {
    }

    public List<Registration> start(BGPExtensionProviderContext context) {
        ArrayList<Registration> regs = new ArrayList<Registration>();
        regs.add(context.registerAddressFamily((AddressFamily)Ipv4AddressFamily.VALUE, 1));
        regs.add(context.registerAddressFamily((AddressFamily)Ipv6AddressFamily.VALUE, 2));
        regs.add(context.registerSubsequentAddressFamily((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE, 1));
        regs.add(context.registerSubsequentAddressFamily((SubsequentAddressFamily)MplsLabeledVpnSubsequentAddressFamily.VALUE, 128));
        BGPActivator.registerExtendedCommunities(regs, context);
        BGPActivator.registerCapabilityParsers(regs, context);
        BGPActivator.registerAttributeParsers(regs, context);
        BGPActivator.registerMessageParsers(regs, context);
        return regs;
    }

    private static void registerCapabilityParsers(List<Registration> regs, BGPExtensionProviderContext context) {
        AddressFamilyRegistry afiReg = context.getAddressFamilyRegistry();
        SubsequentAddressFamilyRegistry safiReg = context.getSubsequentAddressFamilyRegistry();
        MultiProtocolCapabilityHandler multi = new MultiProtocolCapabilityHandler(afiReg, safiReg);
        regs.add(context.registerCapabilityParser(1, (CapabilityParser)multi));
        regs.add(context.registerCapabilitySerializer(MultiprotocolCapability.class, (CapabilitySerializer)multi));
        AddPathCapabilityHandler addPath = new AddPathCapabilityHandler(afiReg, safiReg);
        regs.add(context.registerCapabilityParser(69, (CapabilityParser)addPath));
        regs.add(context.registerCapabilitySerializer(AddPathCapability.class, (CapabilitySerializer)addPath));
        RouteRefreshCapabilityHandler routeRefresh = new RouteRefreshCapabilityHandler();
        regs.add(context.registerCapabilityParser(2, (CapabilityParser)routeRefresh));
        regs.add(context.registerCapabilitySerializer(RouteRefreshCapability.class, (CapabilitySerializer)routeRefresh));
        As4CapabilityHandler as4 = new As4CapabilityHandler();
        regs.add(context.registerCapabilityParser(65, (CapabilityParser)as4));
        regs.add(context.registerCapabilitySerializer(As4BytesCapability.class, (CapabilitySerializer)as4));
        GracefulCapabilityHandler grace = new GracefulCapabilityHandler(afiReg, safiReg);
        regs.add(context.registerCapabilitySerializer(GracefulRestartCapability.class, (CapabilitySerializer)grace));
        regs.add(context.registerCapabilityParser(64, (CapabilityParser)grace));
        LlGracefulCapabilityHandler llgrace = new LlGracefulCapabilityHandler(afiReg, safiReg);
        regs.add(context.registerCapabilitySerializer(LlGracefulRestartCapability.class, (CapabilitySerializer)llgrace));
        regs.add(context.registerCapabilityParser(71, (CapabilityParser)llgrace));
        CapabilityParameterParser cpp = new CapabilityParameterParser(context.getCapabilityRegistry());
        regs.add(context.registerParameterParser(2, (ParameterParser)cpp));
        regs.add(context.registerParameterSerializer(BgpParameters.class, (ParameterSerializer)cpp));
        BgpExtendedMessageCapabilityHandler bgpextmessage = new BgpExtendedMessageCapabilityHandler();
        regs.add(context.registerCapabilityParser(6, (CapabilityParser)bgpextmessage));
        regs.add(context.registerCapabilitySerializer(BgpExtendedMessageCapability.class, (CapabilitySerializer)bgpextmessage));
    }

    private static void registerAttributeParsers(List<Registration> regs, BGPExtensionProviderContext context) {
        BgpPrefixSidAttributeParser prefixSidAttributeParser = new BgpPrefixSidAttributeParser(context.getBgpPrefixSidTlvRegistry());
        regs.add(context.registerAttributeSerializer(BgpPrefixSid.class, (AttributeSerializer)prefixSidAttributeParser));
        regs.add(context.registerAttributeParser(40, (AttributeParser)prefixSidAttributeParser));
        OriginAttributeParser originAttributeParser = new OriginAttributeParser();
        regs.add(context.registerAttributeSerializer(Origin.class, (AttributeSerializer)originAttributeParser));
        regs.add(context.registerAttributeParser(1, (AttributeParser)originAttributeParser));
        AigpAttributeParser aigpAttributeParser = new AigpAttributeParser();
        regs.add(context.registerAttributeSerializer(Aigp.class, (AttributeSerializer)aigpAttributeParser));
        regs.add(context.registerAttributeParser(26, (AttributeParser)aigpAttributeParser));
        AsPathAttributeParser asPathAttributeParser = new AsPathAttributeParser(context.getReferenceCache());
        regs.add(context.registerAttributeSerializer(AsPath.class, (AttributeSerializer)asPathAttributeParser));
        regs.add(context.registerAttributeParser(2, (AttributeParser)asPathAttributeParser));
        NextHopAttributeParser nextHopAttributeParser = new NextHopAttributeParser();
        regs.add(context.registerAttributeSerializer(NextHop.class, (AttributeSerializer)nextHopAttributeParser));
        regs.add(context.registerAttributeParser(3, (AttributeParser)nextHopAttributeParser));
        MultiExitDiscriminatorAttributeParser multiExitDiscriminatorAttributeParser = new MultiExitDiscriminatorAttributeParser();
        regs.add(context.registerAttributeSerializer(MultiExitDisc.class, (AttributeSerializer)multiExitDiscriminatorAttributeParser));
        regs.add(context.registerAttributeParser(4, (AttributeParser)multiExitDiscriminatorAttributeParser));
        LocalPreferenceAttributeParser localPreferenceAttributeParser = new LocalPreferenceAttributeParser();
        regs.add(context.registerAttributeSerializer(LocalPref.class, (AttributeSerializer)localPreferenceAttributeParser));
        regs.add(context.registerAttributeParser(5, (AttributeParser)localPreferenceAttributeParser));
        AtomicAggregateAttributeParser atomicAggregateAttributeParser = new AtomicAggregateAttributeParser();
        regs.add(context.registerAttributeSerializer(AtomicAggregate.class, (AttributeSerializer)atomicAggregateAttributeParser));
        regs.add(context.registerAttributeParser(6, (AttributeParser)atomicAggregateAttributeParser));
        AggregatorAttributeParser as4AggregatorAttributeParser = new AggregatorAttributeParser(context.getReferenceCache());
        regs.add(context.registerAttributeSerializer(Aggregator.class, (AttributeSerializer)as4AggregatorAttributeParser));
        regs.add(context.registerAttributeParser(7, (AttributeParser)as4AggregatorAttributeParser));
        CommunitiesAttributeParser communitiesAttributeParser = new CommunitiesAttributeParser(context.getReferenceCache());
        regs.add(context.registerAttributeSerializer(Communities.class, (AttributeSerializer)communitiesAttributeParser));
        regs.add(context.registerAttributeParser(8, (AttributeParser)communitiesAttributeParser));
        OriginatorIdAttributeParser originatorIdAttributeParser = new OriginatorIdAttributeParser();
        regs.add(context.registerAttributeSerializer(OriginatorId.class, (AttributeSerializer)originatorIdAttributeParser));
        regs.add(context.registerAttributeParser(9, (AttributeParser)originatorIdAttributeParser));
        ClusterIdAttributeParser clusterIdAttributeParser = new ClusterIdAttributeParser();
        regs.add(context.registerAttributeSerializer(ClusterId.class, (AttributeSerializer)clusterIdAttributeParser));
        regs.add(context.registerAttributeParser(10, (AttributeParser)clusterIdAttributeParser));
        NlriRegistry nlriReg = context.getNlriRegistry();
        MPReachAttributeParser mpReachAttributeParser = new MPReachAttributeParser(nlriReg);
        regs.add(context.registerAttributeSerializer(MpReachNlri.class, (AttributeSerializer)mpReachAttributeParser));
        regs.add(context.registerAttributeParser(14, (AttributeParser)mpReachAttributeParser));
        MPUnreachAttributeParser mpUnreachAttributeParser = new MPUnreachAttributeParser(nlriReg);
        regs.add(context.registerAttributeSerializer(MpUnreachNlri.class, (AttributeSerializer)mpUnreachAttributeParser));
        regs.add(context.registerAttributeParser(15, (AttributeParser)mpUnreachAttributeParser));
        ExtendedCommunitiesAttributeParser extendedCommunitiesAttributeParser = new ExtendedCommunitiesAttributeParser(context.getExtendedCommunityRegistry());
        regs.add(context.registerAttributeSerializer(ExtendedCommunities.class, (AttributeSerializer)extendedCommunitiesAttributeParser));
        regs.add(context.registerAttributeParser(16, (AttributeParser)extendedCommunitiesAttributeParser));
        regs.add(context.registerAttributeParser(17, (AttributeParser)new AS4AggregatorAttributeParser()));
        regs.add(context.registerAttributeParser(18, (AttributeParser)new AS4PathAttributeParser()));
        regs.add(context.registerAttributeSerializer(UnrecognizedAttributes.class, (AttributeSerializer)new UnrecognizedAttributesSerializer()));
    }

    private static void registerMessageParsers(List<Registration> regs, BGPExtensionProviderContext context) {
        BGPOpenMessageParser omp = new BGPOpenMessageParser(context.getParameterRegistry());
        regs.add(context.registerMessageParser(1, (MessageParser)omp));
        regs.add(context.registerMessageSerializer(Open.class, (MessageSerializer)omp));
        BGPUpdateMessageParser ump = new BGPUpdateMessageParser(context.getAttributeRegistry(), context.getNlriRegistry());
        regs.add(context.registerMessageParser(2, (MessageParser)ump));
        regs.add(context.registerMessageSerializer(Update.class, (MessageSerializer)ump));
        BGPNotificationMessageParser nmp = new BGPNotificationMessageParser();
        regs.add(context.registerMessageParser(3, (MessageParser)nmp));
        regs.add(context.registerMessageSerializer(Notify.class, (MessageSerializer)nmp));
        BGPKeepAliveMessageParser kamp = new BGPKeepAliveMessageParser();
        regs.add(context.registerMessageParser(4, (MessageParser)kamp));
        regs.add(context.registerMessageSerializer(Keepalive.class, (MessageSerializer)kamp));
        AddressFamilyRegistry afiReg = context.getAddressFamilyRegistry();
        SubsequentAddressFamilyRegistry safiReg = context.getSubsequentAddressFamilyRegistry();
        BGPRouteRefreshMessageParser rrmp = new BGPRouteRefreshMessageParser(afiReg, safiReg);
        regs.add(context.registerMessageParser(5, (MessageParser)rrmp));
        regs.add(context.registerMessageSerializer(RouteRefresh.class, (MessageSerializer)rrmp));
    }

    private static void registerExtendedCommunities(List<Registration> regs, BGPExtensionProviderContext context) {
        AsTwoOctetSpecificEcHandler twoOctetSpecificEcHandler = new AsTwoOctetSpecificEcHandler();
        regs.add(context.registerExtendedCommunityParser(twoOctetSpecificEcHandler.getType(true), twoOctetSpecificEcHandler.getSubType(), (ExtendedCommunityParser)twoOctetSpecificEcHandler));
        regs.add(context.registerExtendedCommunityParser(twoOctetSpecificEcHandler.getType(false), twoOctetSpecificEcHandler.getSubType(), (ExtendedCommunityParser)twoOctetSpecificEcHandler));
        regs.add(context.registerExtendedCommunitySerializer(AsSpecificExtendedCommunityCase.class, (ExtendedCommunitySerializer)twoOctetSpecificEcHandler));
        Ipv4SpecificEcHandler ipv4SpecificEcHandler = new Ipv4SpecificEcHandler();
        regs.add(context.registerExtendedCommunityParser(ipv4SpecificEcHandler.getType(true), ipv4SpecificEcHandler.getSubType(), (ExtendedCommunityParser)ipv4SpecificEcHandler));
        regs.add(context.registerExtendedCommunityParser(ipv4SpecificEcHandler.getType(false), ipv4SpecificEcHandler.getSubType(), (ExtendedCommunityParser)ipv4SpecificEcHandler));
        regs.add(context.registerExtendedCommunitySerializer(Inet4SpecificExtendedCommunityCase.class, (ExtendedCommunitySerializer)ipv4SpecificEcHandler));
        OpaqueEcHandler opaqueEcHandler = new OpaqueEcHandler();
        regs.add(context.registerExtendedCommunityParser(opaqueEcHandler.getType(true), opaqueEcHandler.getSubType(), (ExtendedCommunityParser)opaqueEcHandler));
        regs.add(context.registerExtendedCommunityParser(opaqueEcHandler.getType(false), opaqueEcHandler.getSubType(), (ExtendedCommunityParser)opaqueEcHandler));
        regs.add(context.registerExtendedCommunitySerializer(OpaqueExtendedCommunityCase.class, (ExtendedCommunitySerializer)opaqueEcHandler));
        RouteOriginAsTwoOctetEcHandler routeOriginAS2bEcHandler = new RouteOriginAsTwoOctetEcHandler();
        regs.add(context.registerExtendedCommunityParser(routeOriginAS2bEcHandler.getType(true), routeOriginAS2bEcHandler.getSubType(), (ExtendedCommunityParser)routeOriginAS2bEcHandler));
        regs.add(context.registerExtendedCommunityParser(routeOriginAS2bEcHandler.getType(false), routeOriginAS2bEcHandler.getSubType(), (ExtendedCommunityParser)routeOriginAS2bEcHandler));
        regs.add(context.registerExtendedCommunitySerializer(RouteOriginExtendedCommunityCase.class, (ExtendedCommunitySerializer)routeOriginAS2bEcHandler));
        RouteTargetAsTwoOctetEcHandler routeTargetAS2bEcHandler = new RouteTargetAsTwoOctetEcHandler();
        regs.add(context.registerExtendedCommunityParser(routeTargetAS2bEcHandler.getType(true), routeTargetAS2bEcHandler.getSubType(), (ExtendedCommunityParser)routeTargetAS2bEcHandler));
        regs.add(context.registerExtendedCommunityParser(routeTargetAS2bEcHandler.getType(false), routeTargetAS2bEcHandler.getSubType(), (ExtendedCommunityParser)routeTargetAS2bEcHandler));
        regs.add(context.registerExtendedCommunitySerializer(RouteTargetExtendedCommunityCase.class, (ExtendedCommunitySerializer)routeTargetAS2bEcHandler));
        RouteOriginIpv4EcHandler routeOriginIpv4EcHandler = new RouteOriginIpv4EcHandler();
        regs.add(context.registerExtendedCommunityParser(routeOriginIpv4EcHandler.getType(true), routeOriginIpv4EcHandler.getSubType(), (ExtendedCommunityParser)routeOriginIpv4EcHandler));
        regs.add(context.registerExtendedCommunityParser(routeOriginIpv4EcHandler.getType(false), routeOriginIpv4EcHandler.getSubType(), (ExtendedCommunityParser)routeOriginIpv4EcHandler));
        regs.add(context.registerExtendedCommunitySerializer(RouteOriginIpv4Case.class, (ExtendedCommunitySerializer)routeOriginIpv4EcHandler));
        RouteTargetIpv4EcHandler routeTargetIpv4EcHandler = new RouteTargetIpv4EcHandler();
        regs.add(context.registerExtendedCommunityParser(routeTargetIpv4EcHandler.getType(true), routeTargetIpv4EcHandler.getSubType(), (ExtendedCommunityParser)routeTargetIpv4EcHandler));
        regs.add(context.registerExtendedCommunityParser(routeTargetIpv4EcHandler.getType(false), routeTargetIpv4EcHandler.getSubType(), (ExtendedCommunityParser)routeTargetIpv4EcHandler));
        regs.add(context.registerExtendedCommunitySerializer(RouteTargetIpv4Case.class, (ExtendedCommunitySerializer)routeTargetIpv4EcHandler));
        LinkBandwidthEC linkBandwidthECHandler = new LinkBandwidthEC();
        regs.add(context.registerExtendedCommunityParser(linkBandwidthECHandler.getType(false), linkBandwidthECHandler.getSubType(), (ExtendedCommunityParser)linkBandwidthECHandler));
        regs.add(context.registerExtendedCommunitySerializer(LinkBandwidthCase.class, (ExtendedCommunitySerializer)linkBandwidthECHandler));
        Generic4OctASEcHandler gen4OctASEcHandler = new Generic4OctASEcHandler();
        regs.add(context.registerExtendedCommunityParser(gen4OctASEcHandler.getType(true), gen4OctASEcHandler.getSubType(), (ExtendedCommunityParser)gen4OctASEcHandler));
        regs.add(context.registerExtendedCommunityParser(gen4OctASEcHandler.getType(false), gen4OctASEcHandler.getSubType(), (ExtendedCommunityParser)gen4OctASEcHandler));
        regs.add(context.registerExtendedCommunitySerializer(As4GenericSpecExtendedCommunityCase.class, (ExtendedCommunitySerializer)gen4OctASEcHandler));
        RouteTarget4OctectASEcHandler rt4ASHandler = new RouteTarget4OctectASEcHandler();
        regs.add(context.registerExtendedCommunityParser(rt4ASHandler.getType(true), rt4ASHandler.getSubType(), (ExtendedCommunityParser)rt4ASHandler));
        regs.add(context.registerExtendedCommunitySerializer(As4RouteTargetExtendedCommunityCase.class, (ExtendedCommunitySerializer)rt4ASHandler));
        RouteOrigin4OctectASEcHandler rOrig4Oct = new RouteOrigin4OctectASEcHandler();
        regs.add(context.registerExtendedCommunityParser(rOrig4Oct.getType(true), rOrig4Oct.getSubType(), (ExtendedCommunityParser)rOrig4Oct));
        regs.add(context.registerExtendedCommunitySerializer(As4RouteOriginExtendedCommunityCase.class, (ExtendedCommunitySerializer)rOrig4Oct));
        EncapsulationEC encapsulationECHandler = new EncapsulationEC();
        regs.add(context.registerExtendedCommunityParser(encapsulationECHandler.getType(true), encapsulationECHandler.getSubType(), (ExtendedCommunityParser)encapsulationECHandler));
        regs.add(context.registerExtendedCommunitySerializer(EncapsulationCase.class, (ExtendedCommunitySerializer)encapsulationECHandler));
        VrfRouteImportHandler vrfRouteImportHandler = new VrfRouteImportHandler();
        regs.add(context.registerExtendedCommunityParser(vrfRouteImportHandler.getType(true), vrfRouteImportHandler.getSubType(), (ExtendedCommunityParser)vrfRouteImportHandler));
        regs.add(context.registerExtendedCommunitySerializer(VrfRouteImportExtendedCommunityCase.class, (ExtendedCommunitySerializer)vrfRouteImportHandler));
        SourceAS4OctectHandler source4ASHandler = new SourceAS4OctectHandler();
        regs.add(context.registerExtendedCommunityParser(source4ASHandler.getType(true), source4ASHandler.getSubType(), (ExtendedCommunityParser)source4ASHandler));
        regs.add(context.registerExtendedCommunitySerializer(SourceAs4ExtendedCommunityCase.class, (ExtendedCommunitySerializer)source4ASHandler));
        SourceASHandler sourceASHandler = new SourceASHandler();
        regs.add(context.registerExtendedCommunityParser(sourceASHandler.getType(true), sourceASHandler.getSubType(), (ExtendedCommunityParser)sourceASHandler));
        regs.add(context.registerExtendedCommunitySerializer(SourceAsExtendedCommunityCase.class, (ExtendedCommunitySerializer)sourceASHandler));
    }
}

