/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterLengthOverflowException;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.protocol.bgp.parser.spi.ParameterUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.BgpParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.OptionalCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CapabilityParameterParser
implements ParameterParser,
ParameterSerializer {
    public static final int TYPE = 2;
    private static final Logger LOG = LoggerFactory.getLogger(CapabilityParameterParser.class);
    private final CapabilityRegistry reg;

    public CapabilityParameterParser(CapabilityRegistry reg) {
        this.reg = Objects.requireNonNull(reg);
    }

    public BgpParameters parseParameter(ByteBuf buffer) throws BGPParsingException, BGPDocumentedException {
        Preconditions.checkArgument((buffer != null && buffer.readableBytes() != 0 ? 1 : 0) != 0, (Object)"Byte array cannot be null or empty.");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Started parsing of BGP Capabilities: {}", (Object)Arrays.toString(ByteArray.getAllBytes((ByteBuf)buffer)));
        }
        ArrayList<OptionalCapabilities> optionalCapas = new ArrayList<OptionalCapabilities>();
        while (buffer.isReadable()) {
            OptionalCapabilities optionalCapa = this.parseOptionalCapability(buffer);
            if (optionalCapa == null) continue;
            optionalCapas.add(optionalCapa);
        }
        return new BgpParametersBuilder().setOptionalCapabilities(optionalCapas).build();
    }

    private OptionalCapabilities parseOptionalCapability(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        short capLength;
        ByteBuf paramBody;
        short capCode = buffer.readUnsignedByte();
        CParameters ret = this.reg.parseCapability((int)capCode, paramBody = buffer.readSlice((int)(capLength = buffer.readUnsignedByte())));
        if (ret == null) {
            LOG.info("Ignoring unsupported capability {}", (Object)capCode);
            return null;
        }
        return new OptionalCapabilitiesBuilder().setCParameters(ret).build();
    }

    public void serializeParameter(BgpParameters parameter, ByteBuf output) throws ParameterLengthOverflowException {
        ByteBuf buffer = this.serializeOptionalCapabilities(parameter.getOptionalCapabilities());
        if (buffer != null) {
            ParameterUtil.formatParameter((int)2, (ByteBuf)buffer, (ByteBuf)output);
        }
    }

    public void serializeExtendedParameter(BgpParameters parameter, ByteBuf output) {
        ByteBuf buffer = this.serializeOptionalCapabilities(parameter.getOptionalCapabilities());
        if (buffer != null) {
            ParameterUtil.formatExtendedParameter((int)2, (ByteBuf)buffer, (ByteBuf)output);
        }
    }

    private ByteBuf serializeOptionalCapabilities(List<OptionalCapabilities> capabilities) {
        if (capabilities == null) {
            return null;
        }
        ByteBuf buffer = Unpooled.buffer();
        for (OptionalCapabilities optionalCapa : capabilities) {
            LOG.trace("Started serializing BGP Capability: {}", (Object)optionalCapa);
            this.serializeOptionalCapability(optionalCapa, buffer);
        }
        return buffer;
    }

    private void serializeOptionalCapability(OptionalCapabilities optionalCapa, ByteBuf byteAggregator) {
        if (optionalCapa.getCParameters() != null) {
            CParameters cap = optionalCapa.getCParameters();
            ByteBuf bytes = Unpooled.buffer();
            this.reg.serializeCapability(cap, bytes);
            Preconditions.checkArgument((bytes != null ? 1 : 0) != 0, (String)"Unhandled capability class %s", (Object)cap.implementedInterface());
            if (LOG.isTraceEnabled()) {
                LOG.trace("BGP capability serialized to: {}", (Object)ByteBufUtil.hexDump((ByteBuf)bytes));
            }
            byteAggregator.writeBytes(bytes);
        }
    }
}

