/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.routing.types.rev171204.Uint24;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.TablesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LlGracefulCapabilityHandler
implements CapabilityParser,
CapabilitySerializer {
    public static final int CODE = 71;
    private static final Logger LOG = LoggerFactory.getLogger(LlGracefulCapabilityHandler.class);
    private static final int AFI_SAFI_SIZE = 3;
    private static final int AFI_FLAGS_SIZE = 1;
    private static final int STALE_TIME_SIZE = 3;
    private static final int PER_TABLE_SIZE = 7;
    private static final int MAX_STALE_TIME = 0xFFFFFF;
    private static final byte AFI_FLAG_FORWARDING_STATE = -128;
    private final AddressFamilyRegistry afiReg;
    private final SubsequentAddressFamilyRegistry safiReg;

    public LlGracefulCapabilityHandler(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiReg = Objects.requireNonNull(afiReg);
        this.safiReg = Objects.requireNonNull(safiReg);
    }

    public CParameters parseCapability(ByteBuf buffer) {
        BindingMap.Builder tables = BindingMap.builder();
        while (buffer.isReadable()) {
            short afival = buffer.readShort();
            AddressFamily afi = this.afiReg.classForFamily((int)afival);
            if (afi == null) {
                LOG.debug("Ignoring GR capability for unknown address family {}", (Object)afival);
                buffer.skipBytes(5);
                continue;
            }
            byte safival = buffer.readByte();
            SubsequentAddressFamily safi = this.safiReg.classForFamily((int)safival);
            if (safi == null) {
                LOG.debug("Ignoring GR capability for unknown subsequent address family {}", (Object)safival);
                buffer.skipBytes(4);
                continue;
            }
            byte afiFlags = buffer.readByte();
            int staleTime = buffer.readUnsignedMedium();
            Tables table = new TablesBuilder().setAfi(afi).setSafi(safi).setAfiFlags(new Tables.AfiFlags(Boolean.valueOf(afiFlags == -128))).setLongLivedStaleTime(new Uint24(Uint32.valueOf((int)staleTime))).build();
            tables.add((Identifiable)table);
        }
        return new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setLlGracefulRestartCapability(new LlGracefulRestartCapabilityBuilder().setTables(tables.build()).build()).build()).build();
    }

    public void serializeCapability(CParameters capability, ByteBuf byteAggregator) {
        LlGracefulRestartCapability cap;
        CParameters1 aug = (CParameters1)capability.augmentation(CParameters1.class);
        if (aug != null && (cap = aug.getLlGracefulRestartCapability()) != null) {
            CapabilityUtil.formatCapability((int)71, (ByteBuf)this.serializeCapability(cap), (ByteBuf)byteAggregator);
        }
    }

    private ByteBuf serializeCapability(LlGracefulRestartCapability cap) {
        Map tables = cap.getTables();
        if (tables == null || tables.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf buffer = Unpooled.buffer((int)(7 * tables.size()));
        for (Tables table : tables.values()) {
            AddressFamily afi = table.getAfi();
            Integer afival = this.afiReg.numberForClass(afi);
            Preconditions.checkArgument((afival != null ? 1 : 0) != 0, (String)"Unhandled address family %s", (Object)afi);
            buffer.writeShort(afival.intValue());
            SubsequentAddressFamily safi = table.getSafi();
            Integer safival = this.safiReg.numberForClass(safi);
            Preconditions.checkArgument((safival != null ? 1 : 0) != 0, (String)"Unhandled subsequent address family %s", (Object)safi);
            buffer.writeByte(safival.intValue());
            if (table.getAfiFlags() != null && table.getAfiFlags().getForwardingState().booleanValue()) {
                buffer.writeByte(-128);
            } else {
                buffer.writeByte(0);
            }
            Uint24 staleTime = table.getLongLivedStaleTime();
            int timeval = staleTime != null ? staleTime.getValue().intValue() : 0;
            Preconditions.checkArgument((timeval >= 0 && timeval <= 0xFFFFFF ? 1 : 0) != 0, (String)"Restart time is %s", (Object)staleTime);
            buffer.writeMedium(timeval);
        }
        return buffer;
    }
}

