/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.protocol.bgp.parser.spi.MultiprotocolCapabilitiesUtil;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public final class MultiProtocolCapabilityHandler
implements CapabilityParser,
CapabilitySerializer {
    public static final int CODE = 1;
    private final AddressFamilyRegistry afiReg;
    private final SubsequentAddressFamilyRegistry safiReg;

    public MultiProtocolCapabilityHandler(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiReg = Objects.requireNonNull(afiReg);
        this.safiReg = Objects.requireNonNull(safiReg);
    }

    public CParameters parseCapability(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        Optional parsedAfiSafiOptional = MultiprotocolCapabilitiesUtil.parseMPAfiSafi((ByteBuf)buffer, (AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg);
        return parsedAfiSafiOptional.map(bgpTableType -> new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder(bgpTableType).build()).build()).build()).orElse(null);
    }

    public void serializeCapability(CParameters capability, ByteBuf byteAggregator) {
        CParameters1 aug = (CParameters1)capability.augmentation(CParameters1.class);
        if (aug == null) {
            return;
        }
        MultiprotocolCapability mp = aug.getMultiprotocolCapability();
        if (mp == null) {
            return;
        }
        ByteBuf capBuffer = Unpooled.buffer();
        MultiprotocolCapabilitiesUtil.serializeMPAfiSafi((AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg, (AddressFamily)mp.getAfi(), (SubsequentAddressFamily)mp.getSafi(), (ByteBuf)capBuffer);
        CapabilityUtil.formatCapability((int)1, (ByteBuf)capBuffer, (ByteBuf)byteAggregator);
    }
}

