/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ShortAsNumber;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregatorAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AggregatorAttributeParser.class);
    private static final int AGGREGATOR_LENGTH = 8;
    public static final int TYPE = 7;
    private final ReferenceCache refCache;

    public AggregatorAttributeParser(ReferenceCache refCache) {
        this.refCache = Objects.requireNonNull(refCache);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) {
        if (buffer.readableBytes() != 8 && errorHandling != RevisedErrorHandling.NONE) {
            LOG.debug("Discarded malformed AGGREGATOR attribute");
            return;
        }
        builder.setAggregator(new AggregatorBuilder().setAsNumber((AsNumber)this.refCache.getSharedReference((Object)new AsNumber(ByteBufUtils.readUint32((ByteBuf)buffer)))).setNetworkAddress(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).build());
    }

    public void serializeAttribute(Attributes pathAttributes, ByteBuf byteAggregator) {
        AsNumber asNumber;
        Aggregator aggregator = pathAttributes.getAggregator();
        if (aggregator != null && (asNumber = aggregator.getAsNumber()) != null) {
            AttributeUtil.formatAttribute((int)192, (int)7, (ByteBuf)Unpooled.buffer((int)8).writeInt(new ShortAsNumber(asNumber).getValue().intValue()).writeBytes(Ipv4Util.bytesForAddress((Ipv4AddressNoZone)aggregator.getNetworkAddress())), (ByteBuf)byteAggregator);
        }
    }
}

