/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class AsPathSegmentParser {
    public static final int AS_NUMBER_LENGTH = 4;

    private AsPathSegmentParser() {
    }

    static int serializeType(SegmentType type) {
        switch (type) {
            case AS_SET: {
                return 1;
            }
            case AS_SEQUENCE: {
                return 2;
            }
        }
        return 0;
    }

    static SegmentType parseType(int type) {
        switch (type) {
            case 1: {
                return SegmentType.AS_SET;
            }
            case 2: {
                return SegmentType.AS_SEQUENCE;
            }
        }
        return null;
    }

    static ImmutableList<AsNumber> parseAsSegment(ReferenceCache refCache, int count, ByteBuf buffer) {
        if (count == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder coll = ImmutableList.builderWithExpectedSize((int)count);
        for (int i = 0; i < count; ++i) {
            coll.add((Object)((AsNumber)refCache.getSharedReference((Object)new AsNumber(ByteBufUtils.readUint32((ByteBuf)buffer)))));
        }
        return coll.build();
    }

    static void serializeAsList(Collection<AsNumber> asList, SegmentType type, ByteBuf byteAggregator) {
        if (asList == null) {
            return;
        }
        byteAggregator.writeByte(AsPathSegmentParser.serializeType(type));
        byteAggregator.writeByte(asList.size());
        for (AsNumber asNumber : asList) {
            byteAggregator.writeInt(asNumber.getValue().intValue());
        }
    }

    public static enum SegmentType {
        AS_SEQUENCE,
        AS_SET;

    }
}

