/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtomicAggregateAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    public static final int TYPE = 6;
    private static final Logger LOG = LoggerFactory.getLogger(AtomicAggregateAttributeParser.class);
    private static final AtomicAggregate ATOMIC_AGGREGATE = new AtomicAggregateBuilder().build();

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) {
        if (!buffer.isReadable() && errorHandling != RevisedErrorHandling.NONE) {
            LOG.debug("Discarded malformed ATOMIC_AGGREGATE attribute");
            return;
        }
        builder.setAtomicAggregate(ATOMIC_AGGREGATE);
    }

    public void serializeAttribute(Attributes pathAttributes, ByteBuf byteAggregator) {
        if (pathAttributes.getAtomicAggregate() != null) {
            AttributeUtil.formatAttribute((int)64, (int)6, (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)byteAggregator);
        }
    }
}

