/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ClusterIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterIdAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterIdAttributeParser.class);
    public static final int TYPE = 10;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        if (errorHandling == RevisedErrorHandling.EXTERNAL) {
            LOG.debug("Discarded CLUSTER_LIST attribute from external peer");
            return;
        }
        int readable = buffer.readableBytes();
        if (readable == 0 && errorHandling != RevisedErrorHandling.NONE) {
            throw new BGPTreatAsWithdrawException(BGPError.ATTR_LENGTH_ERROR, "Empty CLUSTER_LIST attribute", new Object[0]);
        }
        if (readable % 4 != 0) {
            throw errorHandling.reportError(BGPError.ATTR_LENGTH_ERROR, "Length of CLUSTER_LIST should be a multiple of 4, but is %s", new Object[]{readable});
        }
        int count = readable / 4;
        ArrayList<ClusterIdentifier> list = new ArrayList<ClusterIdentifier>(count);
        for (int i = 0; i < count; ++i) {
            list.add(new ClusterIdentifier(Ipv4Util.addressForByteBuf((ByteBuf)buffer)));
        }
        builder.setClusterId(new ClusterIdBuilder().setCluster(list).build());
    }

    public void serializeAttribute(Attributes pathAttributes, ByteBuf byteAggregator) {
        List cluster;
        ClusterId cid = pathAttributes.getClusterId();
        if (cid != null && (cluster = cid.getCluster()) != null && !cluster.isEmpty()) {
            ByteBuf clusterIdBuffer = Unpooled.buffer();
            for (ClusterIdentifier clusterIdentifier : cluster) {
                clusterIdBuffer.writeBytes(Ipv4Util.bytesForAddress((Ipv4AddressNoZone)clusterIdentifier));
            }
            AttributeUtil.formatAttribute((int)128, (int)10, (ByteBuf)clusterIdBuffer, (ByteBuf)byteAggregator);
        }
    }
}

