/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Community;

public final class CommunitiesAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    public static final int TYPE = 8;
    private static final int COMMUNITY_LENGTH = 4;
    private static final byte[] NO_EXPORT = new byte[]{-1, -1, -1, 1};
    private static final byte[] NO_ADVERTISE = new byte[]{-1, -1, -1, 2};
    private static final byte[] NO_EXPORT_SUBCONFED = new byte[]{-1, -1, -1, 3};
    private static final byte[] LLGR_STALE = new byte[]{-1, -1, 0, 6};
    private static final byte[] NO_LLGR = new byte[]{-1, -1, 0, 7};
    private final ReferenceCache refCache;

    public CommunitiesAttributeParser(ReferenceCache refCache) {
        this.refCache = Objects.requireNonNull(refCache);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        int readable = buffer.readableBytes();
        if (readable == 0 && errorHandling != RevisedErrorHandling.NONE) {
            throw new BGPTreatAsWithdrawException(BGPError.ATTR_LENGTH_ERROR, "Empty Community attribute", new Object[0]);
        }
        if (readable % 4 != 0) {
            throw errorHandling.reportError(BGPError.ATTR_LENGTH_ERROR, "Community attribute length must be a multiple of %s, have %s", new Object[]{4, readable});
        }
        int count = readable / 4;
        ArrayList<Communities> set = new ArrayList<Communities>(count);
        for (int i = 0; i < count; ++i) {
            set.add((Communities)CommunitiesAttributeParser.parseCommunity(this.refCache, buffer.readSlice(4)));
        }
        builder.setCommunities(set);
    }

    private static Community parseCommunity(ReferenceCache refCache, ByteBuf buffer) throws BGPDocumentedException {
        if (buffer.readableBytes() != 4) {
            throw new BGPDocumentedException("Community with wrong length: " + buffer.readableBytes(), BGPError.OPT_ATTR_ERROR);
        }
        byte[] body = ByteArray.getBytes((ByteBuf)buffer, (int)4);
        if (Arrays.equals(body, NO_EXPORT)) {
            return CommunityUtil.NO_EXPORT;
        }
        if (Arrays.equals(body, NO_ADVERTISE)) {
            return CommunityUtil.NO_ADVERTISE;
        }
        if (Arrays.equals(body, NO_EXPORT_SUBCONFED)) {
            return CommunityUtil.NO_EXPORT_SUBCONFED;
        }
        if (Arrays.equals(body, LLGR_STALE)) {
            return CommunityUtil.LLGR_STALE;
        }
        if (Arrays.equals(body, NO_LLGR)) {
            return CommunityUtil.NO_LLGR;
        }
        return CommunityUtil.create(refCache, buffer.readUnsignedShort(), buffer.readUnsignedShort());
    }

    public void serializeAttribute(Attributes pathAttributes, ByteBuf byteAggregator) {
        List communities = pathAttributes.getCommunities();
        if (communities == null || communities.isEmpty()) {
            return;
        }
        ByteBuf communitiesBuffer = Unpooled.buffer();
        for (Community community : communities) {
            communitiesBuffer.writeShort((int)community.getAsNumber().getValue().shortValue());
            communitiesBuffer.writeShort((int)community.getSemantics().shortValue());
        }
        AttributeUtil.formatAttribute((int)192, (int)8, (ByteBuf)communitiesBuffer, (ByteBuf)byteAggregator);
    }
}

