/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import java.util.Objects;
import org.opendaylight.protocol.util.NoopReferenceCache;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.CommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Community;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public final class CommunityUtil {
    public static final Community NO_EXPORT = CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), 65535L, 65281);
    public static final Community NO_ADVERTISE = CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), 65535L, 65282);
    public static final Community NO_EXPORT_SUBCONFED = CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), 65535L, 65283);
    public static final Community LLGR_STALE = CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), 65535L, 6);
    public static final Community NO_LLGR = CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), 65535L, 7);
    private final ReferenceCache refCache;

    public CommunityUtil(ReferenceCache refCache) {
        this.refCache = Objects.requireNonNull(refCache);
    }

    public Community create(long asn, int semantics) {
        return CommunityUtil.create(this.refCache, asn, semantics);
    }

    public static Community create(ReferenceCache refCache, long asn, int semantics) {
        CommunitiesBuilder builder = new CommunitiesBuilder();
        builder.setAsNumber((AsNumber)refCache.getSharedReference((Object)new AsNumber(Uint32.valueOf((long)asn))));
        builder.setSemantics((Uint16)refCache.getSharedReference((Object)Uint16.valueOf((int)semantics)));
        return (Community)refCache.getSharedReference((Object)builder.build());
    }

    public Community valueOf(String string) {
        return CommunityUtil.valueOf(this.refCache, string);
    }

    public static Community valueOf(ReferenceCache refCache, String string) {
        String[] parts = string.split(":", 2);
        CommunitiesBuilder builder = new CommunitiesBuilder();
        builder.setAsNumber((AsNumber)refCache.getSharedReference((Object)new AsNumber(Uint32.valueOf((String)parts[0]))));
        builder.setSemantics((Uint16)refCache.getSharedReference((Object)Uint16.valueOf((String)parts[1])));
        return (Community)refCache.getSharedReference((Object)builder.build());
    }
}

