/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPrefBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalPreferenceAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(LocalPreferenceAttributeParser.class);
    public static final int TYPE = 5;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        if (errorHandling == RevisedErrorHandling.EXTERNAL) {
            LOG.debug("Discarded LOCAL_PREF attribute from external peer");
            return;
        }
        int readable = buffer.readableBytes();
        if (readable != 4) {
            throw errorHandling.reportError(BGPError.ATTR_LENGTH_ERROR, "Expected 4 bytes, have %s", new Object[]{readable});
        }
        builder.setLocalPref(new LocalPrefBuilder().setPref(ByteBufUtils.readUint32((ByteBuf)buffer)).build());
    }

    public void serializeAttribute(Attributes attribute, ByteBuf byteAggregator) {
        Uint32 pref;
        LocalPref lp = attribute.getLocalPref();
        if (lp != null && (pref = lp.getPref()) != null) {
            AttributeUtil.formatAttribute((int)64, (int)5, (ByteBuf)Unpooled.copyInt((int)pref.intValue()), (ByteBuf)byteAggregator);
        }
    }
}

