/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.ReachAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.NlriSerializer;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.AttributesUnreach;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.AttributesUnreachBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public final class MPUnreachAttributeParser
extends ReachAttributeParser {
    public static final int TYPE = 15;
    private final NlriRegistry reg;

    public MPUnreachAttributeParser(NlriRegistry reg) {
        this.reg = Objects.requireNonNull(reg);
    }

    @Override
    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
        try {
            builder.addAugmentation((Augmentation)new AttributesUnreachBuilder().setMpUnreachNlri(this.reg.parseMpUnreach(buffer, constraint)).build());
        }
        catch (BGPParsingException e) {
            throw new BGPDocumentedException("Could not parse MP_UNREACH_NLRI", BGPError.OPT_ATTR_ERROR, (Exception)((Object)e));
        }
    }

    public void serializeAttribute(Attributes attribute, ByteBuf byteAggregator) {
        AttributesUnreach pathAttributes2 = (AttributesUnreach)attribute.augmentation(AttributesUnreach.class);
        if (pathAttributes2 != null) {
            ByteBuf unreachBuffer = Unpooled.buffer();
            this.reg.serializeMpUnReach(pathAttributes2.getMpUnreachNlri(), unreachBuffer);
            for (NlriSerializer nlriSerializer : this.reg.getSerializers()) {
                nlriSerializer.serializeAttribute(attribute, unreachBuffer);
            }
            AttributeUtil.formatAttribute((int)128, (int)15, (ByteBuf)unreachBuffer, (ByteBuf)byteAggregator);
        }
    }
}

