/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDiscBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class MultiExitDiscriminatorAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    public static final int TYPE = 4;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        int readable = buffer.readableBytes();
        if (readable != 4) {
            throw errorHandling.reportError(BGPError.ATTR_LENGTH_ERROR, "MULTI_EXIT_DISC has to have length 4, but has %s", new Object[]{readable});
        }
        builder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(ByteBufUtils.readUint32((ByteBuf)buffer)).build());
    }

    public void serializeAttribute(Attributes attribute, ByteBuf byteAggregator) {
        Uint32 med;
        MultiExitDisc multiExitDisc = attribute.getMultiExitDisc();
        if (multiExitDisc != null && (med = multiExitDisc.getMed()) != null) {
            AttributeUtil.formatAttribute((int)128, (int)4, (ByteBuf)Unpooled.copyInt((int)med.intValue()), (ByteBuf)byteAggregator);
        }
    }
}

