/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.bgp.concepts.NextHopUtil;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;

public final class NextHopAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    public static final int TYPE = 3;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        int readable = buffer.readableBytes();
        builder.setCNextHop(switch (readable) {
            case 4 -> NextHopUtil.parseNextHopIpv4((ByteBuf)buffer);
            case 16 -> NextHopUtil.parseNextHopIpv6((ByteBuf)buffer);
            case 32 -> NextHopUtil.parseNextHopFullIpv6((ByteBuf)buffer);
            default -> throw errorHandling.reportError(BGPError.ATTR_LENGTH_ERROR, "NEXT_HOP attribute is expected to have length of {%s, %s, %s} but has %s", new Object[]{4, 16, 32, readable});
        });
    }

    public void serializeAttribute(Attributes attribute, ByteBuf byteAggregator) {
        CNextHop cNextHop = attribute.getCNextHop();
        if (cNextHop != null) {
            ByteBuf nextHopBuffer = Unpooled.buffer();
            NextHopUtil.serializeNextHop((CNextHop)cNextHop, (ByteBuf)nextHopBuffer);
            AttributeUtil.formatAttribute((int)64, (int)3, (ByteBuf)nextHopBuffer, (ByteBuf)byteAggregator);
        }
    }
}

