/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin;

public final class OriginAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    public static final int TYPE = 1;
    private static final Origin IGP = new OriginBuilder().setValue(BgpOrigin.Igp).build();
    private static final Origin EGP = new OriginBuilder().setValue(BgpOrigin.Egp).build();
    private static final Origin INC = new OriginBuilder().setValue(BgpOrigin.Incomplete).build();

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        int readable = buffer.readableBytes();
        if (readable != 1) {
            throw errorHandling.reportError(BGPError.ATTR_LENGTH_ERROR, "ORIGIN attribute is expected to have size 1, but has %s", new Object[]{readable});
        }
        byte rawOrigin = buffer.readByte();
        BgpOrigin borigin = BgpOrigin.forValue((int)UnsignedBytes.toInt((byte)rawOrigin));
        if (borigin == null) {
            throw errorHandling.reportError(BGPError.ORIGIN_ATTR_NOT_VALID, "Unknown ORIGIN type %s", new Object[]{rawOrigin});
        }
        switch (borigin) {
            case Egp: {
                builder.setOrigin(EGP);
                return;
            }
            case Igp: {
                builder.setOrigin(IGP);
                return;
            }
            case Incomplete: {
                builder.setOrigin(INC);
                return;
            }
        }
    }

    public void serializeAttribute(Attributes attribute, ByteBuf byteAggregator) {
        Origin origin = attribute.getOrigin();
        if (origin != null) {
            AttributeUtil.formatAttribute((int)64, (int)1, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{UnsignedBytes.checkedCast((long)origin.getValue().getIntValue())}), (ByteBuf)byteAggregator);
        }
    }
}

