/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AbstractAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorIdBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OriginatorIdAttributeParser
extends AbstractAttributeParser
implements AttributeSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(OriginatorIdAttributeParser.class);
    public static final int TYPE = 9;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, RevisedErrorHandling errorHandling, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPTreatAsWithdrawException {
        if (errorHandling == RevisedErrorHandling.EXTERNAL) {
            LOG.debug("Discarded ORIGINATOR_ID attribute from external peer");
            return;
        }
        int readable = buffer.readableBytes();
        if (readable != 4) {
            throw errorHandling.reportError(BGPError.ATTR_LENGTH_ERROR, "Length of byte array for ORIGINATOR_ID should be 4, but is %s", new Object[]{readable});
        }
        builder.setOriginatorId(new OriginatorIdBuilder().setOriginator(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).build());
    }

    public void serializeAttribute(Attributes attribute, ByteBuf byteAggregator) {
        Ipv4AddressNoZone address;
        OriginatorId originator = attribute.getOriginatorId();
        if (originator != null && (address = originator.getOriginator()) != null) {
            AttributeUtil.formatAttribute((int)128, (int)9, (ByteBuf)Unpooled.wrappedBuffer((byte[])Ipv4Util.bytesForAddress((Ipv4AddressNoZone)address)), (ByteBuf)byteAggregator);
        }
    }
}

