/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityParser;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunitySerializer;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.LinkBandwidthCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.LinkBandwidthCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.link.bandwidth._case.LinkBandwidthExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.link.bandwidth._case.LinkBandwidthExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;

public class LinkBandwidthEC
implements ExtendedCommunityParser,
ExtendedCommunitySerializer {
    private static final int TYPE = 64;
    private static final int SUBTYPE = 4;
    private static final int BANDWIDTH_SIZE = 4;
    private static final int AS_TRANS_LENGTH = 2;

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        buffer.skipBytes(2);
        LinkBandwidthExtendedCommunity lb = new LinkBandwidthExtendedCommunityBuilder().setBandwidth(new Bandwidth(ByteArray.readBytes((ByteBuf)buffer, (int)4))).build();
        return new LinkBandwidthCaseBuilder().setLinkBandwidthExtendedCommunity(lb).build();
    }

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf body) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof LinkBandwidthCase), (String)"The extended community %s is not LinkBandwidthCase type.", (Object)extendedCommunity);
        LinkBandwidthExtendedCommunity lb = ((LinkBandwidthCase)extendedCommunity).getLinkBandwidthExtendedCommunity();
        body.writeShort(23456);
        ByteBufWriteUtil.writeFloat32((Float32)lb.getBandwidth(), (ByteBuf)body);
    }

    public int getType(boolean isTransitive) {
        return 64;
    }

    public int getSubType() {
        return 4;
    }
}

