/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.AbstractTwoOctetAsExtendedCommunity;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteOriginExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteOriginExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.route.origin.extended.community._case.RouteOriginExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.route.origin.extended.community._case.RouteOriginExtendedCommunityBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;

public final class RouteOriginAsTwoOctetEcHandler
extends AbstractTwoOctetAsExtendedCommunity {
    private static final int SUBTYPE = 3;

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        RouteOriginExtendedCommunity targetOrigin = new RouteOriginExtendedCommunityBuilder().setGlobalAdministrator(new ShortAsNumber(Uint32.valueOf((int)buffer.readUnsignedShort()))).setLocalAdministrator(ByteArray.readBytes((ByteBuf)buffer, (int)4)).build();
        return new RouteOriginExtendedCommunityCaseBuilder().setRouteOriginExtendedCommunity(targetOrigin).build();
    }

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof RouteOriginExtendedCommunityCase), (String)"The extended community %s is not RouteOriginExtendedCommunity type.", (Object)extendedCommunity);
        RouteOriginExtendedCommunity routeOrigin = ((RouteOriginExtendedCommunityCase)extendedCommunity).getRouteOriginExtendedCommunity();
        byteAggregator.writeShort(routeOrigin.getGlobalAdministrator().getValue().intValue());
        byteAggregator.writeBytes(routeOrigin.getLocalAdministrator());
    }

    public int getSubType() {
        return 3;
    }
}

