/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.AbstractIpv4ExtendedCommunity;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteOriginIpv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteOriginIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.route.origin.ipv4._case.RouteOriginIpv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.route.origin.ipv4._case.RouteOriginIpv4Builder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class RouteOriginIpv4EcHandler
extends AbstractIpv4ExtendedCommunity {
    private static final int SUBTYPE = 3;

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof RouteOriginIpv4Case), (String)"The extended community %s is not RouteOriginIpv4Case type.", (Object)extendedCommunity);
        RouteOriginIpv4 routeTarget = ((RouteOriginIpv4Case)extendedCommunity).getRouteOriginIpv4();
        Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)routeTarget.getGlobalAdministrator(), (ByteBuf)byteAggregator);
        ByteBufUtils.writeOrZero((ByteBuf)byteAggregator, (Uint16)routeTarget.getLocalAdministrator());
    }

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        return new RouteOriginIpv4CaseBuilder().setRouteOriginIpv4(new RouteOriginIpv4Builder().setGlobalAdministrator(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).setLocalAdministrator(ByteBufUtils.readUint16((ByteBuf)buffer)).build()).build();
    }

    public int getSubType() {
        return 3;
    }
}

