/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.AbstractTwoOctetAsExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAsExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAsExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.source.as.extended.community._case.SourceAsExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.source.as.extended.community._case.SourceAsExtendedCommunityBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;

public final class SourceASHandler
extends AbstractTwoOctetAsExtendedCommunity {
    private static final short SUBTYPE = 9;
    private static final int LOCAL_ADMIN = 0;

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) {
        SourceAsExtendedCommunityBuilder builder = new SourceAsExtendedCommunityBuilder();
        builder.setGlobalAdministrator(new ShortAsNumber(Uint32.valueOf((int)buffer.readUnsignedShort())));
        buffer.skipBytes(4);
        return new SourceAsExtendedCommunityCaseBuilder().setSourceAsExtendedCommunity(builder.build()).build();
    }

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf body) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof SourceAsExtendedCommunityCase), (String)"The extended community %s is not SourceAsExtendedCommunityCase type.", (Object)extendedCommunity);
        SourceAsExtendedCommunity excomm = ((SourceAsExtendedCommunityCase)extendedCommunity).getSourceAsExtendedCommunity();
        body.writeShort(excomm.getGlobalAdministrator().getValue().intValue());
        body.writeInt(0);
    }

    public int getSubType() {
        return 9;
    }
}

