/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.four.octect.as.specific;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.Abstract4OctetAsExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAs4ExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAs4ExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.source.as._4.extended.community._case.SourceAs4ExtendedCommunityBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class SourceAS4OctectHandler
extends Abstract4OctetAsExtendedCommunity {
    private static final short SUBTYPE = 209;
    private static final int LOCAL_ADMIN = 0;
    private static final short LOCAL_LENGTH = 2;

    public ExtendedCommunity parseExtendedCommunity(ByteBuf body) {
        SourceAs4ExtendedCommunityBuilder builder = new SourceAs4ExtendedCommunityBuilder().setGlobalAdministrator(new AsNumber(ByteBufUtils.readUint32((ByteBuf)body)));
        body.skipBytes(2);
        return new SourceAs4ExtendedCommunityCaseBuilder().setSourceAs4ExtendedCommunity(builder.build()).build();
    }

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf body) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof SourceAs4ExtendedCommunityCase), (String)"The extended community %s is not SourceAs4ExtendedCommunityCase type.", (Object)extendedCommunity);
        ByteBufUtils.write((ByteBuf)body, (Uint32)((SourceAs4ExtendedCommunityCase)extendedCommunity).getSourceAs4ExtendedCommunity().getGlobalAdministrator().getValue());
        body.writeShort(0);
    }

    public int getSubType() {
        return 209;
    }
}

