/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.route.target;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.route.target.ipv4.grouping.RouteTargetIpv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.route.target.ipv4.grouping.RouteTargetIpv4Builder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class RouteTargetIpv4Handler {
    private RouteTargetIpv4Handler() {
    }

    public static void serialize(RouteTargetIpv4 routeTarget, ByteBuf byteAggregator) {
        Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)routeTarget.getGlobalAdministrator(), (ByteBuf)byteAggregator);
        ByteBufUtils.writeOrZero((ByteBuf)byteAggregator, (Uint16)routeTarget.getLocalAdministrator());
    }

    public static RouteTargetIpv4 parse(ByteBuf buffer) {
        return new RouteTargetIpv4Builder().setGlobalAdministrator(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).setLocalAdministrator(ByteBufUtils.readUint16((ByteBuf)buffer)).build();
    }
}

