/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPUpdateMessageParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupport;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.PeerConstraint;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandlingSupport;
import org.opendaylight.protocol.bgp.parser.spi.pojo.PeerSpecificParserConstraintImpl;
import org.opendaylight.protocol.bgp.parser.spi.pojo.RevisedErrorHandlingSupportImpl;
import org.opendaylight.protocol.bgp.util.HexDumpBGPFileParser;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.NoopReferenceCache;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.PathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.UpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPrefBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDiscBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.SegmentsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.NlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.WithdrawnRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.update.message.WithdrawnRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.AttributesUnreach;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.RouteTargetIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.route.target.ipv4.grouping.RouteTargetIpv4Builder;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class BGPParserTest {
    private static final List<byte[]> INPUT_BYTES = new ArrayList<byte[]>();
    private static final int COUNTER = 8;
    private static final int MAX_SIZE = 300;
    private static BGPUpdateMessageParser updateParser;
    private static final int LENGTH_FIELD_LENGTH = 2;
    private static final String MULTIPATH_HEX_FILE = "/bgp-update-multipath.txt";
    private static List<byte[]> updatesWithMultiplePath;
    private static PeerSpecificParserConstraint mpConstraint;
    private static MultiPathSupport mpSupport;

    @BeforeClass
    public static void setUp() throws Exception {
        updateParser = new BGPUpdateMessageParser(ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow().getAttributeRegistry(), (NlriRegistry)Mockito.mock(NlriRegistry.class));
        for (int i = 1; i <= 8; ++i) {
            String name = "/up" + i + ".bin";
            try (InputStream is = BGPParserTest.class.getResourceAsStream(name);){
                if (is == null) {
                    throw new IOException("Failed to get resource " + name);
                }
                ByteArrayOutputStream bis = new ByteArrayOutputStream();
                byte[] data = new byte[300];
                int numRead = 0;
                while ((numRead = is.read(data, 0, data.length)) != -1) {
                    bis.write(data, 0, numRead);
                }
                bis.flush();
                INPUT_BYTES.add(bis.toByteArray());
                is.close();
                continue;
            }
        }
        updatesWithMultiplePath = HexDumpBGPFileParser.parseMessages((InputStream)BGPParserTest.class.getResourceAsStream(MULTIPATH_HEX_FILE));
        mpConstraint = (PeerSpecificParserConstraint)Mockito.mock(PeerSpecificParserConstraint.class);
        mpSupport = (MultiPathSupport)Mockito.mock(MultiPathSupport.class);
        ((PeerSpecificParserConstraint)Mockito.doReturn(Optional.empty()).when((Object)mpConstraint)).getPeerConstraint((Class)ArgumentMatchers.any());
        ((PeerSpecificParserConstraint)Mockito.doReturn(Optional.of(mpSupport)).when((Object)mpConstraint)).getPeerConstraint(MultiPathSupport.class);
        ((MultiPathSupport)Mockito.doReturn((Object)true).when((Object)mpSupport)).isTableTypeSupported((BgpTableType)ArgumentMatchers.any());
    }

    @Test
    public void testResource() {
        Assert.assertNotNull(INPUT_BYTES);
    }

    @Test
    public void testGetUpdateMessage1() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])INPUT_BYTES.get(0), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])INPUT_BYTES.get(0), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, null);
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4AddressNoZone("10.0.0.2")).build()).build();
        List<Communities> comms = List.of((Communities)CommunityUtil.NO_EXPORT, (Communities)CommunityUtil.NO_ADVERTISE, (Communities)CommunityUtil.NO_EXPORT_SUBCONFED, (Communities)CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), (long)65535L, (int)65296));
        UpdateBuilder builder = new UpdateBuilder();
        List<Nlri> nlris = List.of(new NlriBuilder().setPrefix(new Ipv4Prefix("172.17.2.0/24")).build(), new NlriBuilder().setPrefix(new Ipv4Prefix("172.17.1.0/24")).build(), new NlriBuilder().setPrefix(new Ipv4Prefix("172.17.0.0/24")).build());
        Assert.assertEquals(nlris, (Object)message.getNlri());
        builder.setNlri(nlris);
        Attributes attrs = message.getAttributes();
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments(List.of(new SegmentsBuilder().setAsSequence(List.of(new AsNumber(Uint32.valueOf((int)65002)))).build())).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Uint32.ZERO).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setAtomicAggregate(new AtomicAggregateBuilder().build());
        Assert.assertEquals((Object)paBuilder.getAtomicAggregate(), (Object)attrs.getAtomicAggregate());
        paBuilder.setCommunities(comms);
        Assert.assertEquals((Object)paBuilder.getCommunities(), (Object)attrs.getCommunities());
        paBuilder.setUnrecognizedAttributes(Map.of());
        builder.setAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])INPUT_BYTES.get(0), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage3() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])INPUT_BYTES.get(2), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])INPUT_BYTES.get(2), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, null);
        UpdateBuilder builder = new UpdateBuilder();
        List<Nlri> nlris = List.of(new NlriBuilder().setPrefix(new Ipv4Prefix("172.16.0.0/21")).build());
        builder.setNlri(nlris);
        Assert.assertEquals((Object)builder.getNlri(), (Object)message.getNlri());
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        List<Segments> asPath = List.of(new SegmentsBuilder().setAsSequence(List.of(new AsNumber(Uint32.valueOf((int)30)))).build(), new SegmentsBuilder().setAsSet((Set)ImmutableSet.of((Object)new AsNumber(Uint32.TEN), (Object)new AsNumber(Uint32.valueOf((int)20)))).build());
        Aggregator aggregator = new AggregatorBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)30))).setNetworkAddress(new Ipv4AddressNoZone("10.0.0.9")).build();
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4AddressNoZone("10.0.0.9")).build()).build();
        Attributes attrs = message.getAttributes();
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Incomplete).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments(asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Uint32.ZERO).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setAggregator(aggregator);
        Assert.assertEquals((Object)paBuilder.getAggregator(), (Object)attrs.getAggregator());
        paBuilder.setUnrecognizedAttributes(Map.of());
        builder.setAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])INPUT_BYTES.get(2), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage4() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])INPUT_BYTES.get(3), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])INPUT_BYTES.get(3), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, null);
        UpdateBuilder builder = new UpdateBuilder();
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        List<Nlri> nlris = List.of(new NlriBuilder().setPrefix(new Ipv4Prefix("10.30.3.0/24")).build(), new NlriBuilder().setPrefix(new Ipv4Prefix("10.30.2.0/24")).build(), new NlriBuilder().setPrefix(new Ipv4Prefix("10.30.1.0/24")).build());
        Assert.assertEquals(nlris, (Object)message.getNlri());
        builder.setNlri(nlris);
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4AddressNoZone("3.3.3.3")).build()).build();
        List<ExtendedCommunities> comms = List.of(new ExtendedCommunitiesBuilder().setTransitive(Boolean.valueOf(true)).setExtendedCommunity((ExtendedCommunity)new RouteTargetIpv4CaseBuilder().setRouteTargetIpv4(new RouteTargetIpv4Builder().setGlobalAdministrator(new Ipv4AddressNoZone("192.168.1.0")).setLocalAdministrator(Uint16.valueOf((int)4660)).build()).build()).build());
        Attributes attrs = message.getAttributes();
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Egp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments(List.of()).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Uint32.ZERO).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setLocalPref(new LocalPrefBuilder().setPref(Uint32.valueOf((int)100)).build());
        Assert.assertEquals((Object)paBuilder.getLocalPref(), (Object)attrs.getLocalPref());
        paBuilder.setExtendedCommunities(comms);
        Assert.assertEquals((Object)paBuilder.getExtendedCommunities(), (Object)attrs.getExtendedCommunities());
        paBuilder.setUnrecognizedAttributes(Map.of());
        builder.setAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])INPUT_BYTES.get(3), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage5() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])INPUT_BYTES.get(4), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])INPUT_BYTES.get(4), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, null);
        List<WithdrawnRoutes> withdrawnRoutes = List.of(new WithdrawnRoutesBuilder().setPrefix(new Ipv4Prefix("172.16.0.4/30")).build());
        Update expectedMessage = new UpdateBuilder().setWithdrawnRoutes(withdrawnRoutes).build();
        Assert.assertEquals((Object)expectedMessage.getWithdrawnRoutes(), (Object)message.getWithdrawnRoutes());
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])INPUT_BYTES.get(4), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testEORIpv4() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])INPUT_BYTES.get(5), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])INPUT_BYTES.get(5), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, null);
        Assert.assertEquals((Object)new UpdateBuilder().build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])INPUT_BYTES.get(5), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testEORIpv6() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])INPUT_BYTES.get(6), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])INPUT_BYTES.get(6), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, null);
        AddressFamily afi = ((AttributesUnreach)message.getAttributes().augmentation(AttributesUnreach.class)).getMpUnreachNlri().getAfi();
        SubsequentAddressFamily safi = ((AttributesUnreach)message.getAttributes().augmentation(AttributesUnreach.class)).getMpUnreachNlri().getSafi();
        Assert.assertEquals((Object)Ipv6AddressFamily.VALUE, (Object)afi);
        Assert.assertEquals((Object)UnicastSubsequentAddressFamily.VALUE, (Object)safi);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])INPUT_BYTES.get(6), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testEORIpv6exLength() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])INPUT_BYTES.get(6), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])INPUT_BYTES.get(6), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, null);
        AddressFamily afi = ((AttributesUnreach)message.getAttributes().augmentation(AttributesUnreach.class)).getMpUnreachNlri().getAfi();
        SubsequentAddressFamily safi = ((AttributesUnreach)message.getAttributes().augmentation(AttributesUnreach.class)).getMpUnreachNlri().getSafi();
        Assert.assertEquals((Object)Ipv6AddressFamily.VALUE, (Object)afi);
        Assert.assertEquals((Object)UnicastSubsequentAddressFamily.VALUE, (Object)safi);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])INPUT_BYTES.get(6), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testUpdateMessageNlriAddPath() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])updatesWithMultiplePath.get(0), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])updatesWithMultiplePath.get(0), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, mpConstraint);
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        List<Segments> asPath = List.of(new SegmentsBuilder().setAsSequence(List.of(new AsNumber(Uint32.valueOf((int)65002)))).build());
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4AddressNoZone("10.0.0.2")).build()).build();
        List<Communities> comms = List.of((Communities)CommunityUtil.NO_EXPORT, (Communities)CommunityUtil.NO_ADVERTISE, (Communities)CommunityUtil.NO_EXPORT_SUBCONFED, (Communities)CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), (long)65535L, (int)65296));
        UpdateBuilder builder = new UpdateBuilder();
        List<Nlri> nlris = List.of(new NlriBuilder().setPrefix(new Ipv4Prefix("172.17.1.0/24")).setPathId(new PathId(Uint32.ONE)).build(), new NlriBuilder().setPrefix(new Ipv4Prefix("172.17.1.0/24")).setPathId(new PathId(Uint32.TWO)).build(), new NlriBuilder().setPrefix(new Ipv4Prefix("172.17.0.0/24")).setPathId(new PathId(Uint32.ONE)).build());
        Assert.assertEquals(nlris, (Object)message.getNlri());
        builder.setNlri(nlris);
        Attributes attrs = message.getAttributes();
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments(asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Uint32.ZERO).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setAtomicAggregate(new AtomicAggregateBuilder().build());
        Assert.assertEquals((Object)paBuilder.getAtomicAggregate(), (Object)attrs.getAtomicAggregate());
        paBuilder.setCommunities(comms);
        Assert.assertEquals((Object)paBuilder.getCommunities(), (Object)attrs.getCommunities());
        paBuilder.setUnrecognizedAttributes(Map.of());
        builder.setAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])updatesWithMultiplePath.get(0), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testUpdateMessageWithdrawAddPath() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])updatesWithMultiplePath.get(1), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])updatesWithMultiplePath.get(1), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, mpConstraint);
        List<WithdrawnRoutes> withdrawnRoutes = List.of(new WithdrawnRoutesBuilder().setPrefix(new Ipv4Prefix("172.16.0.4/30")).setPathId(new PathId(Uint32.ONE)).build(), new WithdrawnRoutesBuilder().setPrefix(new Ipv4Prefix("172.16.0.4/30")).setPathId(new PathId(Uint32.TWO)).build());
        Update expectedMessage = new UpdateBuilder().setWithdrawnRoutes(withdrawnRoutes).build();
        Assert.assertEquals((Object)expectedMessage.getWithdrawnRoutes(), (Object)message.getWithdrawnRoutes());
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])updatesWithMultiplePath.get(1), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testUpdateMessageWithMalformedAttribute() throws BGPDocumentedException {
        byte[] body = ByteArray.cutBytes((byte[])INPUT_BYTES.get(7), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])INPUT_BYTES.get(6), (int)16, (int)2));
        PeerSpecificParserConstraintImpl constraint = new PeerSpecificParserConstraintImpl();
        constraint.addPeerConstraint(RevisedErrorHandlingSupport.class, (PeerConstraint)RevisedErrorHandlingSupportImpl.forExternalPeer());
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength, (PeerSpecificParserConstraint)constraint);
        Assert.assertNotNull((Object)message);
        Assert.assertNull((Object)message.getNlri());
        List withdrawnRoutes = message.getWithdrawnRoutes();
        Assert.assertNotNull((Object)withdrawnRoutes);
        Assert.assertEquals((long)1L, (long)withdrawnRoutes.size());
    }
}

