/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.TablesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class ComplementaryTest {
    @Test
    public void testBGPParameter() {
        MultiprotocolCapability cap = new MultiprotocolCapabilityBuilder().setAfi((AddressFamily)Ipv6AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build();
        CParameters tlv1 = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setMultiprotocolCapability(cap).build()).build();
        MultiprotocolCapability cap1 = new MultiprotocolCapabilityBuilder().setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build();
        CParameters tlv2 = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setMultiprotocolCapability(cap1).build()).build();
        Map tt = BindingMap.of((Identifiable)new TablesBuilder().setAfi((AddressFamily)Ipv6AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build(), (Identifiable)new TablesBuilder().setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build());
        GracefulRestartCapability tlv3 = new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.FALSE.booleanValue())).setRestartTime(Uint16.ZERO).setTables(tt).build();
        CParameters tlv4 = new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)40))).build()).build();
        Assert.assertFalse((boolean)tlv3.getRestartFlags().getRestartState());
        Assert.assertEquals((long)0L, (long)tlv3.getRestartTime().intValue());
        Assert.assertNotEquals((Object)tlv1, (Object)tlv2);
        Assert.assertNotSame((Object)tlv1.hashCode(), (Object)tlv3.hashCode());
        Assert.assertNotSame((Object)tlv2.toString(), (Object)tlv3.toString());
        Assert.assertEquals((Object)tt, (Object)tlv3.getTables());
        Assert.assertEquals((Object)cap.getSafi(), (Object)cap1.getSafi());
        Assert.assertNotSame((Object)cap.getAfi(), (Object)cap1.getAfi());
        Assert.assertEquals((long)40L, (long)tlv4.getAs4BytesCapability().getAsNumber().getValue().longValue());
        Assert.assertEquals((Object)new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)40))).build()).build(), (Object)tlv4);
    }

    @Test
    public void testBGPAggregatorImpl() {
        Aggregator ipv4 = new AggregatorBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)5524))).setNetworkAddress(new Ipv4AddressNoZone("124.55.42.1")).build();
        Aggregator ipv4i = new AggregatorBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)5525))).setNetworkAddress(new Ipv4AddressNoZone("124.55.42.1")).build();
        Assert.assertNotSame((Object)ipv4.hashCode(), (Object)ipv4i.hashCode());
        Assert.assertNotSame((Object)ipv4.getAsNumber(), (Object)ipv4i.getAsNumber());
        Assert.assertEquals((Object)ipv4.getNetworkAddress(), (Object)ipv4i.getNetworkAddress());
    }
}

