/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.pojo.DefaultBGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.KeepaliveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Notify;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.NotifyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.RouteRefresh;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.RouteRefreshBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ParserTest {
    private static final byte[] OPEN_BMSG = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 29, 1, 4, 0, 100, 0, -76, 20, 20, 20, 20, 0};
    private static final byte[] KEEPALIVE_BMSG = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4};
    private static final byte[] NOTIFICATION_BMSG = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 23, 3, 2, 4, 4, 9};
    private static final byte[] UPD_MSG_WITH_UNRECOGNIZED_ATTRIBUTE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 121, 2, 0, 0, 0, 98, -112, 14, 0, 52, 64, 4, 71, 4, 10, 25, 2, 27, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 0, 72, 2, 1, 0, 4, 40, 40, 40, 40, 2, 3, 0, 6, 0, 0, 0, 0, 0, 67, 64, 1, 1, 0, 64, 2, 0, 64, 5, 4, 0, 0, 0, 100, 0, 99, 25, 4, 2, 0, 8, 79, 102, 45, 57, 107, 45, 48, 51, 4, 3, 0, 1, 114, 4, 4, 0, 4, 43, 43, 43, 43};
    private static final byte[] UPD_MSG_WITH_MANDATORY_ATTRIBUTES_PRESENT = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 56, 2, 0, 0, 0, 28, 64, 1, 1, 0, 64, 2, 0, 64, 3, 4, 10, 18, -94, -15, -128, 4, 4, 0, 0, 0, 0, 64, 5, 4, 0, 0, 0, 100, 32, -64, -88, -2, 3};
    private static final byte[] UPD_MSG_WITH_ONE_MANDATORY_ATTRIBUTE_NOT_PRESENT = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 52, 2, 0, 0, 0, 24, 64, 2, 0, 64, 3, 4, 10, 18, -94, -15, -128, 4, 4, 0, 0, 0, 0, 64, 5, 4, 0, 0, 0, 100, 32, -64, -88, -2, 3};
    private static final byte[] UPD_MSG_WITH_MULTIPLE_MANDATORY_ATTRIBUTES_NOT_PRESENT = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 42, 2, 0, 0, 0, 14, -128, 4, 4, 0, 0, 0, 0, 64, 5, 4, 0, 0, 0, 100, 32, -64, -88, -2, 3};
    private static final byte[] RR_MSG = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 23, 5, 0, 1, 0, 1};
    private static MessageRegistry reg;

    @BeforeClass
    public static void setupClass() throws Exception {
        reg = new DefaultBGPExtensionConsumerContext().getMessageRegistry();
    }

    @Test
    public void testHeaderErrors() throws BGPParsingException, BGPDocumentedException {
        byte[] wrong = ByteArray.cutBytes((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0}, (int)16);
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])wrong), null));
        Assert.assertEquals((Object)("Too few bytes in passed array. Passed: " + wrong.length + ". Expected: >= 19."), (Object)ex.getMessage());
    }

    @Test
    public void testBadMsgType() throws BGPParsingException {
        byte[] bytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 8};
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])bytes), null));
        Assert.assertEquals((Object)BGPError.BAD_MSG_TYPE, (Object)ex.getError());
    }

    @Test
    public void testKeepAliveMsg() throws BGPParsingException, BGPDocumentedException {
        Keepalive keepAlive = new KeepaliveBuilder().build();
        ByteBuf buffer = Unpooled.buffer();
        reg.serializeMessage((Notification)keepAlive, buffer);
        Assert.assertArrayEquals((byte[])KEEPALIVE_BMSG, (byte[])ByteArray.getAllBytes((ByteBuf)buffer));
        Notification m = reg.parseMessage(Unpooled.copiedBuffer((byte[])ByteArray.getAllBytes((ByteBuf)buffer)), null);
        MatcherAssert.assertThat((Object)m, (Matcher)CoreMatchers.instanceOf(Keepalive.class));
    }

    @Test
    public void testBadKeepAliveMsg() throws BGPParsingException {
        byte[] bytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 20, 4, 5};
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])bytes), null));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Message length field not within valid range."));
        Assert.assertEquals((Object)BGPError.BAD_MSG_LENGTH, (Object)ex.getError());
    }

    @Test
    public void testOpenMessage() throws BGPParsingException, BGPDocumentedException {
        Open open = new OpenBuilder().setMyAsNumber(Uint16.valueOf((int)100)).setHoldTimer(Uint16.valueOf((int)180)).setBgpIdentifier(new Ipv4AddressNoZone("20.20.20.20")).setVersion(new ProtocolVersion(Uint8.valueOf((int)4))).build();
        ByteBuf bytes = Unpooled.buffer();
        reg.serializeMessage((Notification)open, bytes);
        Assert.assertArrayEquals((byte[])OPEN_BMSG, (byte[])ByteArray.getAllBytes((ByteBuf)bytes));
        Notification m = reg.parseMessage(Unpooled.copiedBuffer((ByteBuf)bytes), null);
        MatcherAssert.assertThat((Object)m, (Matcher)CoreMatchers.instanceOf(Open.class));
        Open mo = (Open)m;
        Assert.assertEquals((long)100L, (long)mo.getMyAsNumber().intValue());
        Assert.assertEquals((long)180L, (long)mo.getHoldTimer().intValue());
        Assert.assertEquals((Object)new Ipv4Address("20.20.20.20"), (Object)mo.getBgpIdentifier());
        Assert.assertNull((Object)mo.getBgpParameters());
    }

    @Test
    public void testBadHoldTimeError() {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 29, 1, 4, 0, 100, 0, 1, 20, 20, 20, 20, 0};
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg), null));
        Assert.assertEquals((Object)"Hold time value not acceptable.", (Object)ex.getMessage());
        Assert.assertEquals((Object)BGPError.HOLD_TIME_NOT_ACC, (Object)ex.getError());
    }

    @Test
    public void testBadMsgLength() {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 27, 1, 4, 0, 100, 0, -76, -1, -1, -1};
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg), null));
        Assert.assertEquals((Object)"Open message too small.", (Object)ex.getMessage());
        Assert.assertEquals((Object)BGPError.BAD_MSG_LENGTH, (Object)ex.getError());
    }

    @Test
    public void testBadVersion() {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 29, 1, 8, 0, 100, 0, -76, 20, 20, 20, 20, 0};
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg), null));
        Assert.assertEquals((Object)"BGP Protocol version 8 not supported.", (Object)ex.getMessage());
        Assert.assertEquals((Object)BGPError.VERSION_NOT_SUPPORTED, (Object)ex.getError());
    }

    @Test
    public void testNotificationMsg() throws BGPParsingException, BGPDocumentedException {
        Notify notMsg = new NotifyBuilder().setErrorCode(BGPError.OPT_PARAM_NOT_SUPPORTED.getCode()).setErrorSubcode(BGPError.OPT_PARAM_NOT_SUPPORTED.getSubcode()).setData(new byte[]{4, 9}).build();
        ByteBuf bytes = Unpooled.buffer();
        reg.serializeMessage((Notification)notMsg, bytes);
        Assert.assertArrayEquals((byte[])NOTIFICATION_BMSG, (byte[])ByteArray.subByte((byte[])bytes.array(), (int)0, (int)bytes.writerIndex()));
        Notification msg = reg.parseMessage(Unpooled.copiedBuffer((ByteBuf)bytes), null);
        Assert.assertTrue((boolean)(msg instanceof Notify));
        Assert.assertEquals((Object)BGPError.OPT_PARAM_NOT_SUPPORTED, (Object)BGPError.forValue((Uint8)((Notify)msg).getErrorCode(), (Uint8)((Notify)msg).getErrorSubcode()));
        Assert.assertArrayEquals((byte[])new byte[]{4, 9}, (byte[])((Notify)msg).getData());
        notMsg = new NotifyBuilder().setErrorCode(BGPError.CONNECTION_NOT_SYNC.getCode()).setErrorSubcode(BGPError.CONNECTION_NOT_SYNC.getSubcode()).build();
        bytes.clear();
        reg.serializeMessage((Notification)notMsg, bytes);
        msg = reg.parseMessage(Unpooled.copiedBuffer((ByteBuf)bytes), null);
        Assert.assertTrue((boolean)(msg instanceof Notify));
        Assert.assertEquals((Object)BGPError.CONNECTION_NOT_SYNC, (Object)BGPError.forValue((Uint8)((Notify)msg).getErrorCode(), (Uint8)((Notify)msg).getErrorSubcode()));
        Assert.assertNull((Object)((Notify)msg).getData());
    }

    @Test
    public void testWrongLength() {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 20, 3, 2};
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg), null));
        Assert.assertEquals((Object)"Notification message too small.", (Object)ex.getMessage());
        Assert.assertEquals((Object)BGPError.BAD_MSG_LENGTH, (Object)ex.getError());
    }

    @Test
    public void testUnrecognizedError() {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 21, 3, 2, -86};
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg), null));
        Assert.assertEquals((Object)"BGP Error code 2 and subcode 170 not recognized.", (Object)ex.getMessage());
    }

    @Test
    public void testParseUpdMsgWithUnrecognizedAttribute() {
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])UPD_MSG_WITH_UNRECOGNIZED_ATTRIBUTE), null));
        Assert.assertEquals((Object)"Well known attribute not recognized.", (Object)ex.getMessage());
        Assert.assertEquals((Object)BGPError.WELL_KNOWN_ATTR_NOT_RECOGNIZED, (Object)ex.getError());
    }

    @Test
    public void testParseUpdMsgWithMandatoryAttributesPresent() throws BGPDocumentedException, BGPParsingException {
        Notification msg = reg.parseMessage(Unpooled.copiedBuffer((byte[])UPD_MSG_WITH_MANDATORY_ATTRIBUTES_PRESENT), null);
        MatcherAssert.assertThat((Object)msg, (Matcher)CoreMatchers.instanceOf(Update.class));
    }

    @Test
    public void testParseUpdMsgWithOneMandatoryAttributeNotPresent() {
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])UPD_MSG_WITH_ONE_MANDATORY_ATTRIBUTE_NOT_PRESENT), null));
        Assert.assertEquals((Object)"Well known mandatory attribute missing: ORIGIN", (Object)ex.getMessage());
        Assert.assertEquals((Object)BGPError.WELL_KNOWN_ATTR_MISSING, (Object)ex.getError());
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])ex.getData());
    }

    @Test
    public void testParseUpdMsgWithMultipleMandatoryAttributesNotPresent() {
        BGPDocumentedException ex = (BGPDocumentedException)Assert.assertThrows(BGPDocumentedException.class, () -> reg.parseMessage(Unpooled.copiedBuffer((byte[])UPD_MSG_WITH_MULTIPLE_MANDATORY_ATTRIBUTES_NOT_PRESENT), null));
        Assert.assertEquals((Object)"Well known mandatory attribute missing: NEXT_HOP", (Object)ex.getMessage());
        Assert.assertEquals((Object)BGPError.WELL_KNOWN_ATTR_MISSING, (Object)ex.getError());
        Assert.assertArrayEquals((byte[])new byte[]{3}, (byte[])ex.getData());
    }

    @Test
    public void testRouteRefreshMsg() throws BGPDocumentedException, BGPParsingException {
        RouteRefresh rrMsg = new RouteRefreshBuilder().setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build();
        ByteBuf buffer = Unpooled.buffer();
        reg.serializeMessage((Notification)rrMsg, buffer);
        Assert.assertArrayEquals((byte[])RR_MSG, (byte[])ByteArray.getAllBytes((ByteBuf)buffer));
        Notification m = reg.parseMessage(Unpooled.copiedBuffer((byte[])ByteArray.getAllBytes((ByteBuf)buffer)), null);
        MatcherAssert.assertThat((Object)m, (Matcher)CoreMatchers.instanceOf(RouteRefresh.class));
    }
}

