/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.SourceASHandler;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.As4GenericSpecExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAsExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.SourceAsExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.source.as.extended.community._case.SourceAsExtendedCommunityBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;

public class SourceASHandlerTest {
    private static final byte[] INPUT = new byte[]{0, 1, 0, 0, 0, 0};
    private final SourceASHandler handler = new SourceASHandler();

    @Test
    public void testHandler() {
        SourceAsExtendedCommunityCase expected = new SourceAsExtendedCommunityCaseBuilder().setSourceAsExtendedCommunity(new SourceAsExtendedCommunityBuilder().setGlobalAdministrator(new ShortAsNumber(Uint32.ONE)).build()).build();
        ExtendedCommunity exComm = this.handler.parseExtendedCommunity(Unpooled.copiedBuffer((byte[])INPUT));
        Assert.assertEquals((Object)expected, (Object)exComm);
        ByteBuf output = Unpooled.buffer((int)INPUT.length);
        this.handler.serializeExtendedCommunity((ExtendedCommunity)expected, output);
        Assert.assertArrayEquals((byte[])INPUT, (byte[])output.array());
        Assert.assertEquals((long)9L, (long)this.handler.getSubType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHandlerError() {
        this.handler.serializeExtendedCommunity((ExtendedCommunity)new As4GenericSpecExtendedCommunityCaseBuilder().build(), null);
    }
}

