/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.open.AddPathCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.SendReceive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.AddPathCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamilies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamiliesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class AddPathCapabilityHandlerTest {
    private static final Ipv6AddressFamily AFI = Ipv6AddressFamily.VALUE;
    private static final UnicastSubsequentAddressFamily SAFI = UnicastSubsequentAddressFamily.VALUE;
    @Mock
    private AddressFamilyRegistry afiRegistry;
    @Mock
    private AddressFamilyRegistry afirExpection;
    @Mock
    private SubsequentAddressFamilyRegistry safiRegistry;
    @Mock
    private SubsequentAddressFamilyRegistry safirException;
    private final ByteBuf parseCorrectBytes = Unpooled.copiedBuffer((byte[])new byte[]{1, 4, 4, 1});
    private final ByteBuf parseWrongBytes = Unpooled.copiedBuffer((byte[])new byte[]{1, 4, 4, 4});
    private final byte[] serializedBytes = new byte[]{69, 4, 1, 4, 4, 1};

    @Before
    public void setUp() {
        ((AddressFamilyRegistry)Mockito.doReturn((Object)260).when((Object)this.afiRegistry)).numberForClass((AddressFamily)AFI);
        ((AddressFamilyRegistry)Mockito.doReturn((Object)AFI).when((Object)this.afiRegistry)).classForFamily(260);
        ((AddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.afirExpection)).numberForClass((AddressFamily)AFI);
        ((AddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.afirExpection)).classForFamily(260);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn((Object)4).when((Object)this.safiRegistry)).numberForClass((SubsequentAddressFamily)SAFI);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn((Object)SAFI).when((Object)this.safiRegistry)).classForFamily(4);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.safirException)).numberForClass((SubsequentAddressFamily)SAFI);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.safirException)).classForFamily(4);
    }

    @Test
    public void testCapabilityHandler() throws BGPDocumentedException, BGPParsingException {
        ArrayList<AddressFamilies> family = new ArrayList<AddressFamilies>();
        family.add(new AddressFamiliesBuilder().setAfi((AddressFamily)AFI).setSafi((SubsequentAddressFamily)SAFI).setSendReceive(SendReceive.forValue((int)1)).build());
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setAddPathCapability(new AddPathCapabilityBuilder().setAddressFamilies(family).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer((int)6);
        AddPathCapabilityHandler handler = new AddPathCapabilityHandler(this.afiRegistry, this.safiRegistry);
        handler.serializeCapability(capabilityToSerialize, bytes);
        Assert.assertArrayEquals((byte[])this.serializedBytes, (byte[])bytes.array());
        CParameters newCaps = handler.parseCapability(this.parseCorrectBytes);
        Assert.assertEquals((long)capabilityToSerialize.hashCode(), (long)newCaps.hashCode());
    }

    @Test(expected=BGPParsingException.class)
    public void testAfiException() throws BGPDocumentedException, BGPParsingException {
        ByteBuf bytes = this.parseWrongBytes.copy();
        AddPathCapabilityHandler handler = new AddPathCapabilityHandler(this.afirExpection, this.safiRegistry);
        handler.parseCapability(bytes);
    }

    @Test(expected=BGPParsingException.class)
    public void testSafiException() throws BGPDocumentedException, BGPParsingException {
        ByteBuf bytes = this.parseWrongBytes.copy();
        AddPathCapabilityHandler handler = new AddPathCapabilityHandler(this.afiRegistry, this.safirException);
        handler.parseCapability(bytes);
    }

    @Test
    public void testSendReceiveIgnored() throws BGPDocumentedException, BGPParsingException {
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setAddPathCapability(new AddPathCapabilityBuilder().setAddressFamilies(new ArrayList()).build()).build()).build();
        ByteBuf bytes = this.parseWrongBytes.copy();
        AddPathCapabilityHandler handler = new AddPathCapabilityHandler(this.afiRegistry, this.safiRegistry);
        CParameters newCaps = handler.parseCapability(bytes);
        Assert.assertEquals((long)capabilityToSerialize.hashCode(), (long)newCaps.hashCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledAfi() {
        ArrayList<AddressFamilies> family = new ArrayList<AddressFamilies>();
        family.add(new AddressFamiliesBuilder().setAfi((AddressFamily)AFI).setSafi((SubsequentAddressFamily)SAFI).setSendReceive(SendReceive.forValue((int)2)).build());
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setAddPathCapability(new AddPathCapabilityBuilder().setAddressFamilies(family).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer();
        AddPathCapabilityHandler handler = new AddPathCapabilityHandler(this.afirExpection, this.safiRegistry);
        handler.serializeCapability(capabilityToSerialize, bytes);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledSafi() {
        ArrayList<AddressFamilies> family = new ArrayList<AddressFamilies>();
        family.add(new AddressFamiliesBuilder().setAfi((AddressFamily)AFI).setSafi((SubsequentAddressFamily)SAFI).setSendReceive(SendReceive.forValue((int)3)).build());
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setAddPathCapability(new AddPathCapabilityBuilder().setAddressFamilies(family).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer();
        AddPathCapabilityHandler handler = new AddPathCapabilityHandler(this.afiRegistry, this.safirException);
        handler.serializeCapability(capabilityToSerialize, bytes);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledSendReceive() {
        ArrayList<AddressFamilies> family = new ArrayList<AddressFamilies>();
        family.add(new AddressFamiliesBuilder().setAfi((AddressFamily)AFI).setSafi((SubsequentAddressFamily)SAFI).setSendReceive(SendReceive.forValue((int)4)).build());
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setAddPathCapability(new AddPathCapabilityBuilder().setAddressFamilies(family).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer();
        AddPathCapabilityHandler handler = new AddPathCapabilityHandler(this.afiRegistry, this.safiRegistry);
        handler.serializeCapability(capabilityToSerialize, bytes);
    }

    @Test
    public void noSerializationTest() {
        CParameters capabilityNoAugmentation = new CParametersBuilder().removeAugmentation(CParameters1.class).build();
        CParameters capabilityNoMP = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().build()).build();
        ByteBuf bytes = Unpooled.buffer();
        AddPathCapabilityHandler handler = new AddPathCapabilityHandler(this.afiRegistry, this.safirException);
        handler.serializeCapability(capabilityNoAugmentation, bytes);
        Assert.assertEquals((long)0L, (long)bytes.readableBytes());
        handler.serializeCapability(capabilityNoMP, bytes);
        Assert.assertEquals((long)0L, (long)bytes.readableBytes());
    }
}

