/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.open.GracefulCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.TablesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.Uint16;

public class GracefulCapabilityHandlerTest {
    private final BGPExtensionConsumerContext ctx = ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow();

    @Test
    public void testGracefulCapabilityHandler() throws BGPDocumentedException, BGPParsingException {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        byte[] capaBytes = new byte[]{64, 6, -127, -12, 0, 1, 1, -128};
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(true)).setRestartTime(Uint16.valueOf((int)500));
        TablesBuilder tablesBuilder = new TablesBuilder().setAfiFlags(new Tables.AfiFlags(true)).setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE);
        capaBuilder.setTables(BindingMap.of((KeyAware)tablesBuilder.build()));
        ByteBuf buffer = Unpooled.buffer((int)capaBytes.length);
        handler.serializeCapability(new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
        Assert.assertArrayEquals((byte[])capaBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes).slice(2, capaBytes.length - 2)));
        byte[] capaBytes2 = new byte[]{64, 6, 0, 0, 0, 1, 1, 0};
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(false));
        capaBuilder.setRestartTime(Uint16.ZERO);
        tablesBuilder.setAfiFlags(new Tables.AfiFlags(false));
        capaBuilder.setTables(BindingMap.of((KeyAware)tablesBuilder.build()));
        buffer.clear();
        handler.serializeCapability(new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
        Assert.assertArrayEquals((byte[])capaBytes2, (byte[])buffer.array());
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes2).slice(2, capaBytes2.length - 2)));
        capaBuilder.setRestartFlags(null);
        tablesBuilder.setAfiFlags(null);
        capaBuilder.setRestartTime((Uint16)null);
        capaBuilder.setTables(BindingMap.of((KeyAware)tablesBuilder.build()));
        buffer.clear();
        handler.serializeCapability(new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
        Assert.assertArrayEquals((byte[])capaBytes2, (byte[])buffer.array());
        byte[] capaBytes3 = new byte[]{64, 6, 0, 0, 0, 0, 0, 0};
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(false));
        capaBuilder.setRestartTime(Uint16.ZERO);
        capaBuilder.setTables(Map.of());
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes3).slice(2, capaBytes3.length - 2)));
        byte[] capaBytes4 = new byte[]{64, 6, 0, 0, 0, 1, 0, 0};
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes4).slice(2, capaBytes4.length - 2)));
        byte[] capaBytes5 = new byte[]{64, 2, 0, 0};
        ByteBuf b = Unpooled.buffer((int)capaBytes5.length);
        handler.serializeCapability(new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(new GracefulRestartCapabilityBuilder().build()).build()).build(), b);
        Assert.assertArrayEquals((byte[])capaBytes5, (byte[])b.array());
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.FALSE.booleanValue())).setRestartTime(Uint16.ZERO).build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes5).slice(2, capaBytes5.length - 2)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledAfi() {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder();
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(true));
        capaBuilder.setRestartTime(Uint16.valueOf((int)50));
        capaBuilder.setTables(BindingMap.of((KeyAware)new TablesBuilder().setAfiFlags(new Tables.AfiFlags(true)).setAfi(AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build()));
        ByteBuf buffer = Unpooled.buffer();
        handler.serializeCapability(new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledSafi() {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder();
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(true));
        capaBuilder.setRestartTime(Uint16.valueOf((int)50));
        capaBuilder.setTables(BindingMap.of((KeyAware)new TablesBuilder().setAfiFlags(new Tables.AfiFlags(true)).setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi(SubsequentAddressFamily.VALUE).build()));
        ByteBuf buffer = Unpooled.buffer();
        handler.serializeCapability(new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRestartTimeMinValue() {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(true)).setRestartTime(Uint16.MAX_VALUE).setTables(BindingMap.of((KeyAware)new TablesBuilder().setAfiFlags(new Tables.AfiFlags(true)).setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build()));
        ByteBuf buffer = Unpooled.buffer();
        handler.serializeCapability(new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRestartTimeMaxValue() {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(true)).setRestartTime(Uint16.valueOf((int)50000));
        capaBuilder.setTables(BindingMap.of((KeyAware)new TablesBuilder().setAfiFlags(new Tables.AfiFlags(true)).setAfi((AddressFamily)Ipv4AddressFamily.VALUE).setSafi((SubsequentAddressFamily)UnicastSubsequentAddressFamily.VALUE).build()));
        ByteBuf buffer = Unpooled.buffer();
        handler.serializeCapability(new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
    }
}

