/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AtomicAggregateBuilder;

public class AtomicAggregateAttributeParserTest {
    private static final byte[] ATTRIBUTE_BYTES = new byte[]{64, 6, 0};
    private static final Attributes RESULT = new AttributesBuilder().setAtomicAggregate(new AtomicAggregateBuilder().build()).build();
    private final AttributeRegistry registry = ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow().getAttributeRegistry();

    @Test
    public void testAttributeParser() throws BGPParsingException, BGPDocumentedException {
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(RESULT, actual);
        Assert.assertArrayEquals((byte[])ATTRIBUTE_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = this.registry.parseAttributes(actual, null).getAttributes();
        Assert.assertEquals((Object)RESULT.getAtomicAggregate(), (Object)attributeOut.getAtomicAggregate());
    }
}

