/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BgpExtendedMessageUtil;
import org.opendaylight.protocol.bgp.parser.impl.message.open.BgpExtendedMessageCapabilityHandler;

public class BgpExtendedMessageCapabilityHandlerTest {
    @Test
    public void testBgpExtendedMessageCapabilityHandler() throws BGPDocumentedException, BGPParsingException {
        BgpExtendedMessageCapabilityHandler handler = new BgpExtendedMessageCapabilityHandler();
        byte[] bgpExeBytes = new byte[]{6, 0};
        ByteBuf buffer = Unpooled.buffer((int)bgpExeBytes.length);
        handler.serializeCapability(BgpExtendedMessageUtil.EXTENDED_MESSAGE_CAPABILITY, buffer);
        Assert.assertArrayEquals((byte[])bgpExeBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])bgpExeBytes)), (Object)BgpExtendedMessageUtil.EXTENDED_MESSAGE_CAPABILITY);
        byte[] bgpExeBytes2 = new byte[]{64, 6};
        buffer.clear();
        handler.serializeCapability(BgpExtendedMessageUtil.EXTENDED_MESSAGE_CAPABILITY, buffer);
        Assert.assertNotSame((Object)bgpExeBytes2, (Object)buffer.array());
    }
}

