/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.open.MultiProtocolCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.MultiprotocolCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.binding.Augmentation;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class MultiProtocolCapabilityHandlerTest {
    private static final Ipv6AddressFamily AFI = Ipv6AddressFamily.VALUE;
    private static final UnicastSubsequentAddressFamily SAFI = UnicastSubsequentAddressFamily.VALUE;
    @Mock
    private AddressFamilyRegistry afir;
    @Mock
    private AddressFamilyRegistry afirExpection;
    @Mock
    private SubsequentAddressFamilyRegistry safir;
    @Mock
    private SubsequentAddressFamilyRegistry safirException;

    @Before
    public void setUp() {
        ((AddressFamilyRegistry)Mockito.doReturn((Object)260).when((Object)this.afir)).numberForClass((AddressFamily)AFI);
        ((AddressFamilyRegistry)Mockito.doReturn((Object)AFI).when((Object)this.afir)).classForFamily(260);
        ((AddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.afirExpection)).numberForClass((AddressFamily)AFI);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn((Object)4).when((Object)this.safir)).numberForClass((SubsequentAddressFamily)SAFI);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn((Object)SAFI).when((Object)this.safir)).classForFamily(4);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.safirException)).numberForClass((SubsequentAddressFamily)SAFI);
    }

    @Test
    public void testCapabilityHandler() throws BGPDocumentedException, BGPParsingException {
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder().setAfi((AddressFamily)AFI).setSafi((SubsequentAddressFamily)SAFI).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afir, this.safir);
        handler.serializeCapability(capabilityToSerialize, bytes);
        CParameters newCaps = handler.parseCapability(bytes);
        Assert.assertEquals((long)capabilityToSerialize.hashCode(), (long)newCaps.hashCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledAfi() {
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder().setAfi((AddressFamily)AFI).setSafi((SubsequentAddressFamily)SAFI).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afirExpection, this.safir);
        handler.serializeCapability(capabilityToSerialize, bytes);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledSafi() {
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder().setAfi((AddressFamily)AFI).setSafi((SubsequentAddressFamily)SAFI).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afir, this.safirException);
        handler.serializeCapability(capabilityToSerialize, bytes);
    }

    @Test
    public void noSerializationTest() {
        CParameters capabilityNoAugmentation = new CParametersBuilder().removeAugmentation(CParameters1.class).build();
        CParameters capabilityNoMP = new CParametersBuilder().addAugmentation((Augmentation)new CParameters1Builder().build()).build();
        ByteBuf bytes = Unpooled.buffer();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afir, this.safirException);
        handler.serializeCapability(capabilityNoAugmentation, bytes);
        Assert.assertEquals((long)0L, (long)bytes.readableBytes());
        handler.serializeCapability(capabilityNoMP, bytes);
        Assert.assertEquals((long)0L, (long)bytes.readableBytes());
    }
}

