/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.BgpPrefixSidAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.bgp.prefix.sid.bgp.prefix.sid.tlvs.BgpPrefixSidTlv;

public final class BgpPrefixSidAttributeParserTest {
    private final BgpPrefixSidTlvRegistry reg = (BgpPrefixSidTlvRegistry)Mockito.mock(BgpPrefixSidTlvRegistry.class);
    private final BgpPrefixSidTlv tlv = (BgpPrefixSidTlv)Mockito.mock(BgpPrefixSidTlv.class);
    private final BgpPrefixSidAttributeParser parser = new BgpPrefixSidAttributeParser(this.reg);
    private final byte[] bytes = new byte[]{1, 2, 3};

    @Before
    public void setUp() {
        ((BgpPrefixSidTlvRegistry)Mockito.doReturn((Object)this.tlv).when((Object)this.reg)).parseBgpPrefixSidTlv(ArgumentMatchers.anyInt(), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
        ((BgpPrefixSidTlvRegistry)Mockito.doNothing().when((Object)this.reg)).serializeBgpPrefixSidTlv((BgpPrefixSidTlv)ArgumentMatchers.any(BgpPrefixSidTlv.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }

    @Test
    public void testHandling() throws BGPDocumentedException, BGPParsingException {
        AttributesBuilder builder = new AttributesBuilder();
        this.parser.parseAttribute(Unpooled.copiedBuffer((byte[])this.bytes), builder, null);
        Assert.assertEquals((long)3L, (long)builder.getBgpPrefixSid().getBgpPrefixSidTlvs().size());
        this.parser.serializeAttribute(builder.build(), Unpooled.EMPTY_BUFFER);
        ((BgpPrefixSidTlvRegistry)Mockito.verify((Object)this.reg, (VerificationMode)Mockito.times((int)3))).serializeBgpPrefixSidTlv((BgpPrefixSidTlv)ArgumentMatchers.any(BgpPrefixSidTlv.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class));
    }
}

