/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.ClusterIdAttributeParser;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ClusterIdentifier;

public class ClusterIdAttributeParserTest {
    private static final byte[] CLUSTER_ID_BYTES = new byte[]{-128, 10, 8, -64, -88, 1, 1, -64, -88, 1, 2};
    ClusterIdAttributeParser parser;

    @Before
    public void setUp() {
        this.parser = new ClusterIdAttributeParser();
    }

    @Test
    public void testParserAttribute() throws Exception {
        ArrayList<ClusterIdentifier> list = new ArrayList<ClusterIdentifier>();
        Ipv4AddressNoZone ip1 = new Ipv4AddressNoZone("192.168.1.1");
        Ipv4AddressNoZone ip2 = new Ipv4AddressNoZone("192.168.1.2");
        list.add(new ClusterIdentifier(ip1));
        list.add(new ClusterIdentifier(ip2));
        Attributes clusterId = new AttributesBuilder().setClusterId(new ClusterIdBuilder().setCluster(list).build()).build();
        ByteBuf output = Unpooled.buffer();
        this.parser.serializeAttribute(clusterId, output);
        Assert.assertArrayEquals((byte[])CLUSTER_ID_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)output));
        AttributesBuilder clusterIdOutput = new AttributesBuilder();
        this.parser.parseAttribute(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])CLUSTER_ID_BYTES, (int)3)), clusterIdOutput, null);
        Assert.assertEquals((Object)clusterId, (Object)clusterIdOutput.build());
    }

    @Test
    public void testParseEmptyListAttribute() {
        ArrayList list = new ArrayList();
        Attributes clusterId = new AttributesBuilder().setClusterId(new ClusterIdBuilder().setCluster(list).build()).build();
        ByteBuf output = Unpooled.buffer();
        this.parser.serializeAttribute(clusterId, output);
        Assert.assertEquals((Object)Unpooled.buffer(), (Object)output);
    }

    @Test
    public void testParseEmptyAttribute() {
        Attributes clusterId = new AttributesBuilder().setClusterId(new ClusterIdBuilder().build()).build();
        ByteBuf output = Unpooled.buffer();
        this.parser.serializeAttribute(clusterId, output);
        Assert.assertEquals((Object)Unpooled.buffer(), (Object)output);
    }
}

