/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.NoopReferenceCache;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;

public class CommunitiesAttributeParserTest {
    private static final byte[] COMMUNITIES_BYTES = new byte[]{-64, 8, 24, -1, -1, -1, 1, -1, -1, -1, 2, -1, -1, -1, 3, -1, -1, -1, 16, -1, -1, 0, 6, -1, -1, 0, 7};
    private final AttributeRegistry registry = ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow().getAttributeRegistry();

    @Test
    public void testCommunitiesAttributeParser() throws Exception {
        ArrayList<Communities> comms = new ArrayList<Communities>();
        comms.add((Communities)CommunityUtil.NO_EXPORT);
        comms.add((Communities)CommunityUtil.NO_ADVERTISE);
        comms.add((Communities)CommunityUtil.NO_EXPORT_SUBCONFED);
        comms.add((Communities)CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), (long)65535L, (int)65296));
        comms.add((Communities)CommunityUtil.LLGR_STALE);
        comms.add((Communities)CommunityUtil.NO_LLGR);
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setCommunities(comms);
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(paBuilder.build(), actual);
        Assert.assertArrayEquals((byte[])COMMUNITIES_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = this.registry.parseAttributes(actual, null).getAttributes();
        Assert.assertEquals(comms, (Object)attributeOut.getCommunities());
    }

    @Test
    public void testParseEmptyListAttribute() {
        ArrayList comms = new ArrayList();
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(new AttributesBuilder().setCommunities(comms).build(), actual);
        Assert.assertEquals((Object)Unpooled.buffer(), (Object)actual);
    }

    @Test
    public void testParseEmptyAttribute() {
        ByteBuf actual = Unpooled.buffer();
        this.registry.serializeAttribute(new AttributesBuilder().build(), actual);
        Assert.assertEquals((Object)Unpooled.buffer(), (Object)actual);
    }
}

