/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionConsumerContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin;

public class OriginAttributeParserTest {
    private static final byte[] IGP_ATTRIBUTE_BYTES = new byte[]{64, 1, 1, 0};
    private static final byte[] EGP_ATTRIBUTE_BYTES = new byte[]{64, 1, 1, 1};
    private static final byte[] INCOMPLETE_ATTRIBUTE_BYTES = new byte[]{64, 1, 1, 2};
    private static final Attributes IGP_RESULT = new AttributesBuilder().setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build()).build();
    private static final Attributes EGP_RESULT = new AttributesBuilder().setOrigin(new OriginBuilder().setValue(BgpOrigin.Egp).build()).build();
    private static final Attributes INCOMPLETE_RESULT = new AttributesBuilder().setOrigin(new OriginBuilder().setValue(BgpOrigin.Incomplete).build()).build();
    private final AttributeRegistry attributeRegistry = ServiceLoader.load(BGPExtensionConsumerContext.class).findFirst().orElseThrow().getAttributeRegistry();

    @Test
    public void testIGPAttributeParser() throws BGPParsingException, BGPDocumentedException {
        ByteBuf actual = Unpooled.buffer();
        this.attributeRegistry.serializeAttribute(IGP_RESULT, actual);
        Assert.assertArrayEquals((byte[])IGP_ATTRIBUTE_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = this.attributeRegistry.parseAttributes(actual, null).getAttributes();
        Assert.assertEquals((Object)IGP_RESULT.getOrigin(), (Object)attributeOut.getOrigin());
    }

    @Test
    public void testEGPAttributeParser() throws BGPParsingException, BGPDocumentedException {
        ByteBuf actual = Unpooled.buffer();
        this.attributeRegistry.serializeAttribute(EGP_RESULT, actual);
        Assert.assertArrayEquals((byte[])EGP_ATTRIBUTE_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = this.attributeRegistry.parseAttributes(actual, null).getAttributes();
        Assert.assertEquals((Object)EGP_RESULT.getOrigin(), (Object)attributeOut.getOrigin());
    }

    @Test
    public void testIncompleeteAttributeParser() throws BGPParsingException, BGPDocumentedException {
        ByteBuf actual = Unpooled.buffer();
        this.attributeRegistry.serializeAttribute(INCOMPLETE_RESULT, actual);
        Assert.assertArrayEquals((byte[])INCOMPLETE_ATTRIBUTE_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = this.attributeRegistry.parseAttributes(actual, null).getAttributes();
        Assert.assertEquals((Object)INCOMPLETE_RESULT.getOrigin(), (Object)attributeOut.getOrigin());
    }

    @Test
    public void testParseEmptyAttribute() {
        String message = ((NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.attributeRegistry.serializeAttribute(new AttributesBuilder().setOrigin(new OriginBuilder().build()).build(), Unpooled.buffer()))).getMessage();
        Assert.assertEquals((Object)"Cannot invoke \"org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin.getIntValue()\" because the return value of \"org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin.getValue()\" is null", (Object)message);
    }
}

