/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.VrfRouteImportHandler;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.As4GenericSpecExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.VrfRouteImportExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.VrfRouteImportExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.vrf.route._import.extended.community._case.VrfRouteImportExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommonBuilder;

public class VrfRouteImportHandlerTest {
    private static final byte[] INPUT = new byte[]{12, 51, 2, 5, 21, 45};
    private final VrfRouteImportHandler handler = new VrfRouteImportHandler();

    @Test
    public void testHandler() {
        VrfRouteImportExtendedCommunityCase expected = new VrfRouteImportExtendedCommunityCaseBuilder().setVrfRouteImportExtendedCommunity(new VrfRouteImportExtendedCommunityBuilder().setInet4SpecificExtendedCommunityCommon(new Inet4SpecificExtendedCommunityCommonBuilder().setGlobalAdministrator(new Ipv4AddressNoZone("12.51.2.5")).setLocalAdministrator(new byte[]{21, 45}).build()).build()).build();
        ExtendedCommunity exComm = this.handler.parseExtendedCommunity(Unpooled.copiedBuffer((byte[])INPUT));
        Assert.assertEquals((Object)expected, (Object)exComm);
        ByteBuf output = Unpooled.buffer((int)INPUT.length);
        this.handler.serializeExtendedCommunity((ExtendedCommunity)expected, output);
        Assert.assertArrayEquals((byte[])INPUT, (byte[])output.array());
        Assert.assertEquals((long)11L, (long)this.handler.getSubType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHandlerError() {
        this.handler.serializeExtendedCommunity((ExtendedCommunity)new As4GenericSpecExtendedCommunityCaseBuilder().build(), null);
    }
}

