/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPUpdateMessageParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.NoopReferenceCache;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.AreaIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.DomainIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.Identifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.Ipv4InterfaceIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.LinkstateAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.LinkstateSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.NlriType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.OspfInterfaceIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.PathAttributes1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.PathAttributes1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.ProtocolId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.linkstate.destination.CLinkstateDestinationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.linkstate.destination.c.linkstate.destination.LinkDescriptorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.linkstate.destination.c.linkstate.destination.LocalNodeDescriptorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.linkstate.destination.c.linkstate.destination.RemoteNodeDescriptorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.node.identifier.CRouterIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.node.identifier.c.router.identifier.OspfNodeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.node.identifier.c.router.identifier.OspfPseudonodeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.node.identifier.c.router.identifier.ospf.node._case.OspfNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.node.identifier.c.router.identifier.ospf.pseudonode._case.OspfPseudonodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.update.path.attributes.LinkstatePathAttributeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.update.path.attributes.linkstate.path.attribute.LinkStateAttribute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.update.path.attributes.linkstate.path.attribute.link.state.attribute.LinkAttributesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.update.path.attributes.linkstate.path.attribute.link.state.attribute.link.attributes._case.LinkAttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.update.path.attributes.mp.reach.nlri.advertized.routes.destination.type.DestinationLinkstateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.update.path.attributes.mp.reach.nlri.advertized.routes.destination.type.DestinationLinkstateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.update.path.attributes.mp.reach.nlri.advertized.routes.destination.type.destination.linkstate._case.DestinationLinkstateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.UpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.bgp.parameters.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AtomicAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.LocalPrefBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.MultiExitDiscBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.OriginBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.OriginatorIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.as.path.SegmentsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.NlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.PathAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.PathAttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.WithdrawnRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.destination.DestinationType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.destination.destination.type.DestinationIpv6CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.destination.destination.type.destination.ipv6._case.DestinationIpv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.MultiprotocolCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.path.attributes.mp.reach.nlri.AdvertizedRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.BgpOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ClusterIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.as.path.segment.CSegment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.as.path.segment.c.segment.AListCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.as.path.segment.c.segment.ASetCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.as.path.segment.c.segment.a.list._case.AListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.as.path.segment.c.segment.a.list._case.a.list.AsSequence;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.as.path.segment.c.segment.a.list._case.a.list.AsSequenceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.as.path.segment.c.segment.a.set._case.ASetBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.Inet4SpecificExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.inet4.specific.extended.community._case.Inet4SpecificExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv4NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv6NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv6NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.ipv6.next.hop._case.Ipv6NextHopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Metric;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.Notification;

public class BGPParserTest {
    static final List<byte[]> inputBytes = new ArrayList<byte[]>();
    private static int COUNTER = 17;
    private static int MAX_SIZE = 300;
    private static BGPUpdateMessageParser updateParser;
    private static final int LENGTH_FIELD_LENGTH = 2;

    @BeforeClass
    public static void setUp() throws Exception {
        updateParser = new BGPUpdateMessageParser(ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getAttributeRegistry());
        for (int i = 1; i <= COUNTER; ++i) {
            String name = "/up" + i + ".bin";
            try (InputStream is = BGPParserTest.class.getResourceAsStream(name);){
                if (is == null) {
                    throw new IOException("Failed to get resource " + name);
                }
                ByteArrayOutputStream bis = new ByteArrayOutputStream();
                byte[] data = new byte[MAX_SIZE];
                int nRead = 0;
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    bis.write(data, 0, nRead);
                }
                bis.flush();
                inputBytes.add(bis.toByteArray());
                is.close();
                continue;
            }
        }
    }

    @Test
    public void testResource() {
        Assert.assertNotNull(inputBytes);
    }

    @Test
    public void testGetUpdateMessage1() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(0), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(0), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        ArrayList asnums = Lists.newArrayList((Object[])new AsSequence[]{new AsSequenceBuilder().setAs(new AsNumber(Long.valueOf(65002L))).build()});
        ArrayList asPath = Lists.newArrayList();
        asPath.add(new SegmentsBuilder().setCSegment((CSegment)new AListCaseBuilder().setAList(new AListBuilder().setAsSequence((List)asnums).build()).build()).build());
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("10.0.0.2")).build()).build();
        ArrayList comms = Lists.newArrayList();
        comms.add((Communities)CommunityUtil.NO_EXPORT);
        comms.add((Communities)CommunityUtil.NO_ADVERTISE);
        comms.add((Communities)CommunityUtil.NO_EXPORT_SUBCONFED);
        comms.add((Communities)CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), (long)65535L, (int)65296));
        UpdateBuilder builder = new UpdateBuilder();
        ArrayList prefs = Lists.newArrayList();
        prefs.add(new Ipv4Prefix("172.17.2.0/24"));
        prefs.add(new Ipv4Prefix("172.17.1.0/24"));
        prefs.add(new Ipv4Prefix("172.17.0.0/24"));
        Nlri nlri = new NlriBuilder().setNlri((List)prefs).build();
        Assert.assertEquals((Object)nlri, (Object)message.getNlri());
        builder.setNlri(nlri);
        PathAttributes attrs = message.getPathAttributes();
        PathAttributesBuilder paBuilder = new PathAttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments((List)asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Long.valueOf(0L)).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setAtomicAggregate(new AtomicAggregateBuilder().build());
        Assert.assertEquals((Object)paBuilder.getAtomicAggregate(), (Object)attrs.getAtomicAggregate());
        paBuilder.setCommunities((List)comms);
        Assert.assertEquals((Object)paBuilder.getCommunities(), (Object)attrs.getCommunities());
        builder.setPathAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(0), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage2() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(1), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(1), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        UpdateBuilder builder = new UpdateBuilder();
        ArrayList prefs = Lists.newArrayList();
        prefs.add(new Ipv6Prefix("2001:db8:1:2::/64"));
        prefs.add(new Ipv6Prefix("2001:db8:1:1::/64"));
        prefs.add(new Ipv6Prefix("2001:db8:1::/64"));
        Assert.assertNull((Object)message.getNlri());
        ArrayList asnums = Lists.newArrayList((Object[])new AsSequence[]{new AsSequenceBuilder().setAs(new AsNumber(Long.valueOf(65001L))).build()});
        ArrayList asPath = Lists.newArrayList();
        asPath.add(new SegmentsBuilder().setCSegment((CSegment)new AListCaseBuilder().setAList(new AListBuilder().setAsSequence((List)asnums).build()).build()).build());
        Ipv6NextHopCase nextHop = new Ipv6NextHopCaseBuilder().setIpv6NextHop(new Ipv6NextHopBuilder().setGlobal(new Ipv6Address("2001:db8::1")).setLinkLocal(new Ipv6Address("fe80::c001:bff:fe7e:0")).build()).build();
        ArrayList clusters = Lists.newArrayList((Object[])new ClusterIdentifier[]{new ClusterIdentifier(new Ipv4Address("1.2.3.4")), new ClusterIdentifier(new Ipv4Address("5.6.7.8"))});
        PathAttributes attrs = message.getPathAttributes();
        PathAttributesBuilder paBuilder = new PathAttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments((List)asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Long.valueOf(0L)).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setOriginatorId(new OriginatorIdBuilder().setOriginator(new Ipv4Address("127.0.0.1")).build());
        Assert.assertEquals((Object)paBuilder.getOriginatorId(), (Object)attrs.getOriginatorId());
        paBuilder.setClusterId(new ClusterIdBuilder().setCluster((List)clusters).build());
        Assert.assertEquals((Object)paBuilder.getClusterId(), (Object)attrs.getClusterId());
        MpReachNlriBuilder mpBuilder = new MpReachNlriBuilder();
        mpBuilder.setAfi(Ipv6AddressFamily.class);
        mpBuilder.setSafi(UnicastSubsequentAddressFamily.class);
        mpBuilder.setCNextHop((CNextHop)nextHop);
        mpBuilder.setAdvertizedRoutes(new AdvertizedRoutesBuilder().setDestinationType((DestinationType)new DestinationIpv6CaseBuilder().setDestinationIpv6(new DestinationIpv6Builder().setIpv6Prefixes((List)prefs).build()).build()).build());
        paBuilder.addAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1.class, (Augmentation)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1Builder().setMpReachNlri(mpBuilder.build()).build());
        Assert.assertEquals((Object)((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1)paBuilder.getAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1.class)).getMpReachNlri(), (Object)((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1)attrs.getAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1.class)).getMpReachNlri());
        builder.setPathAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(1), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage3() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(2), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(2), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        UpdateBuilder builder = new UpdateBuilder();
        Ipv4Prefix pref1 = new Ipv4Prefix("172.16.0.0/21");
        ArrayList nlri = Lists.newArrayList((Object[])new Ipv4Prefix[]{pref1});
        builder.setNlri(new NlriBuilder().setNlri((List)nlri).build());
        Assert.assertEquals((Object)builder.getNlri(), (Object)message.getNlri());
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        ArrayList asnums = Lists.newArrayList((Object[])new AsSequence[]{new AsSequenceBuilder().setAs(new AsNumber(Long.valueOf(30L))).build()});
        ArrayList asPath = Lists.newArrayList();
        asPath.add(new SegmentsBuilder().setCSegment((CSegment)new AListCaseBuilder().setAList(new AListBuilder().setAsSequence((List)asnums).build()).build()).build());
        asPath.add(new SegmentsBuilder().setCSegment((CSegment)new ASetCaseBuilder().setASet(new ASetBuilder().setAsSet((List)Lists.newArrayList((Object[])new AsNumber[]{new AsNumber(Long.valueOf(10L)), new AsNumber(Long.valueOf(20L))})).build()).build()).build());
        Aggregator aggregator = new AggregatorBuilder().setAsNumber(new AsNumber(Long.valueOf(30L))).setNetworkAddress(new Ipv4Address("10.0.0.9")).build();
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("10.0.0.9")).build()).build();
        PathAttributes attrs = message.getPathAttributes();
        PathAttributesBuilder paBuilder = new PathAttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Incomplete).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments((List)asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Long.valueOf(0L)).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setAggregator(aggregator);
        Assert.assertEquals((Object)paBuilder.getAggregator(), (Object)attrs.getAggregator());
        builder.setPathAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(2), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage4() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(3), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(3), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        UpdateBuilder builder = new UpdateBuilder();
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        Ipv4Prefix pref1 = new Ipv4Prefix("10.30.3.0/24");
        Ipv4Prefix pref2 = new Ipv4Prefix("10.30.2.0/24");
        Ipv4Prefix pref3 = new Ipv4Prefix("10.30.1.0/24");
        ArrayList nlri = Lists.newArrayList((Object[])new Ipv4Prefix[]{pref1, pref2, pref3});
        builder.setNlri(new NlriBuilder().setNlri((List)nlri).build());
        Assert.assertEquals((Object)builder.getNlri(), (Object)message.getNlri());
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("3.3.3.3")).build()).build();
        ArrayList comms = Lists.newArrayList();
        comms.add(new ExtendedCommunitiesBuilder().setCommType(Short.valueOf((short)1)).setExtendedCommunity((ExtendedCommunity)new Inet4SpecificExtendedCommunityCaseBuilder().setInet4SpecificExtendedCommunity(new Inet4SpecificExtendedCommunityBuilder().setTransitive(Boolean.valueOf(false)).setGlobalAdministrator(new Ipv4Address("192.168.1.0")).setLocalAdministrator(new byte[]{18, 52}).build()).build()).build());
        ArrayList asPath = Lists.newArrayList();
        PathAttributes attrs = message.getPathAttributes();
        PathAttributesBuilder paBuilder = new PathAttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Egp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments((List)asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Long.valueOf(0L)).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setLocalPref(new LocalPrefBuilder().setPref(Long.valueOf(100L)).build());
        Assert.assertEquals((Object)paBuilder.getLocalPref(), (Object)attrs.getLocalPref());
        paBuilder.setExtendedCommunities((List)comms);
        Assert.assertEquals((Object)paBuilder.getExtendedCommunities(), (Object)attrs.getExtendedCommunities());
        builder.setPathAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(3), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage5() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(4), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(4), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        ArrayList prefs = Lists.newArrayList((Object[])new Ipv4Prefix[]{new Ipv4Prefix("172.16.0.4/30")});
        Update expectedMessage = new UpdateBuilder().setWithdrawnRoutes(new WithdrawnRoutesBuilder().setWithdrawnRoutes((List)prefs).build()).build();
        Assert.assertEquals((Object)expectedMessage.getWithdrawnRoutes(), (Object)message.getWithdrawnRoutes());
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(4), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testEORIpv4() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(5), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(5), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Assert.assertEquals((Object)new UpdateBuilder().build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(5), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testEORIpv6() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(6), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(6), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Class afi = ((PathAttributes2)message.getPathAttributes().getAugmentation(PathAttributes2.class)).getMpUnreachNlri().getAfi();
        Class safi = ((PathAttributes2)message.getPathAttributes().getAugmentation(PathAttributes2.class)).getMpUnreachNlri().getSafi();
        Assert.assertEquals(Ipv6AddressFamily.class, (Object)afi);
        Assert.assertEquals(UnicastSubsequentAddressFamily.class, (Object)safi);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(6), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testEORLS() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(7), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(7), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Class afi = ((PathAttributes2)message.getPathAttributes().getAugmentation(PathAttributes2.class)).getMpUnreachNlri().getAfi();
        Class safi = ((PathAttributes2)message.getPathAttributes().getAugmentation(PathAttributes2.class)).getMpUnreachNlri().getSafi();
        Assert.assertEquals(LinkstateAddressFamily.class, (Object)afi);
        Assert.assertEquals(LinkstateSubsequentAddressFamily.class, (Object)safi);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(7), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testBGPLink() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(8), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(8), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        UpdateBuilder builder = new UpdateBuilder();
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("25.25.25.1")).build()).build();
        ArrayList asPath = Lists.newArrayList();
        LocalNodeDescriptorsBuilder lndBuilder = new LocalNodeDescriptorsBuilder().setAsNumber(new AsNumber(Long.valueOf(100L))).setDomainId(new DomainIdentifier(Long.valueOf(0x19191901L))).setAreaId(new AreaIdentifier(Long.valueOf(0L)));
        RemoteNodeDescriptorsBuilder rndBuilder = new RemoteNodeDescriptorsBuilder().setAsNumber(new AsNumber(Long.valueOf(100L))).setDomainId(new DomainIdentifier(Long.valueOf(0x19191901L))).setAreaId(new AreaIdentifier(Long.valueOf(0L)));
        CLinkstateDestinationBuilder clBuilder = new CLinkstateDestinationBuilder();
        clBuilder.setIdentifier(new Identifier(BigInteger.ONE));
        clBuilder.setNlriType(NlriType.Link);
        clBuilder.setProtocolId(ProtocolId.Ospf);
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1Builder lsBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1Builder();
        MpReachNlriBuilder mpBuilder = new MpReachNlriBuilder();
        mpBuilder.setAfi(LinkstateAddressFamily.class);
        mpBuilder.setSafi(LinkstateSubsequentAddressFamily.class);
        mpBuilder.setCNextHop((CNextHop)nextHop);
        ArrayList linkstates = Lists.newArrayList();
        clBuilder.setLocalNodeDescriptors(lndBuilder.setCRouterIdentifier((CRouterIdentifier)new OspfPseudonodeCaseBuilder().setOspfPseudonode(new OspfPseudonodeBuilder().setOspfRouterId(Long.valueOf(0x3030304L)).setLanInterface(new OspfInterfaceIdentifier(Long.valueOf(0xB0B0B03L))).build()).build()).build());
        clBuilder.setRemoteNodeDescriptors(rndBuilder.setCRouterIdentifier((CRouterIdentifier)new OspfNodeCaseBuilder().setOspfNode(new OspfNodeBuilder().setOspfRouterId(Long.valueOf(0x3030304L)).build()).build()).build());
        clBuilder.setLinkDescriptors(new LinkDescriptorsBuilder().setIpv4InterfaceAddress(new Ipv4InterfaceIdentifier(new Ipv4Address("11.11.11.3"))).build());
        linkstates.add(clBuilder.build());
        clBuilder.setLocalNodeDescriptors(lndBuilder.setCRouterIdentifier((CRouterIdentifier)new OspfPseudonodeCaseBuilder().setOspfPseudonode(new OspfPseudonodeBuilder().setOspfRouterId(Long.valueOf(0x3030304L)).setLanInterface(new OspfInterfaceIdentifier(Long.valueOf(0xB0B0B03L))).build()).build()).build());
        clBuilder.setRemoteNodeDescriptors(rndBuilder.setCRouterIdentifier((CRouterIdentifier)new OspfNodeCaseBuilder().setOspfNode(new OspfNodeBuilder().setOspfRouterId(Long.valueOf(0x1010102L)).build()).build()).build());
        clBuilder.setLinkDescriptors(new LinkDescriptorsBuilder().setIpv4InterfaceAddress(new Ipv4InterfaceIdentifier(new Ipv4Address("11.11.11.1"))).build());
        linkstates.add(clBuilder.build());
        clBuilder.setLocalNodeDescriptors(lndBuilder.setCRouterIdentifier((CRouterIdentifier)new OspfNodeCaseBuilder().setOspfNode(new OspfNodeBuilder().setOspfRouterId(Long.valueOf(0x1010102L)).build()).build()).build());
        clBuilder.setRemoteNodeDescriptors(rndBuilder.setCRouterIdentifier((CRouterIdentifier)new OspfPseudonodeCaseBuilder().setOspfPseudonode(new OspfPseudonodeBuilder().setOspfRouterId(Long.valueOf(0x3030304L)).setLanInterface(new OspfInterfaceIdentifier(Long.valueOf(0xB0B0B03L))).build()).build()).build());
        clBuilder.setLinkDescriptors(new LinkDescriptorsBuilder().setIpv4InterfaceAddress(new Ipv4InterfaceIdentifier(new Ipv4Address("11.11.11.1"))).build());
        linkstates.add(clBuilder.build());
        lsBuilder.setMpReachNlri(mpBuilder.build());
        PathAttributes attrs = message.getPathAttributes();
        PathAttributesBuilder paBuilder = new PathAttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments((List)asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setLocalPref(new LocalPrefBuilder().setPref(Long.valueOf(100L)).build());
        Assert.assertEquals((Object)paBuilder.getLocalPref(), (Object)attrs.getLocalPref());
        MpReachNlri mp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1)attrs.getAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1.class)).getMpReachNlri();
        Assert.assertEquals((Object)mpBuilder.getAfi(), (Object)mp.getAfi());
        Assert.assertEquals((Object)mpBuilder.getSafi(), (Object)mp.getSafi());
        Assert.assertEquals((Object)mpBuilder.getCNextHop(), (Object)mp.getCNextHop());
        DestinationLinkstateBuilder dBuilder = new DestinationLinkstateBuilder();
        dBuilder.setCLinkstateDestination((List)linkstates);
        mpBuilder.setAdvertizedRoutes(new AdvertizedRoutesBuilder().setDestinationType((DestinationType)new DestinationLinkstateCaseBuilder().setDestinationLinkstate(dBuilder.build()).build()).build());
        lsBuilder.setMpReachNlri(mpBuilder.build());
        paBuilder.addAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1.class, (Augmentation)lsBuilder.build());
        PathAttributes1Builder lsAttrBuilder = new PathAttributes1Builder();
        lsAttrBuilder.setLinkstatePathAttribute(new LinkstatePathAttributeBuilder().setLinkStateAttribute((LinkStateAttribute)new LinkAttributesCaseBuilder().setLinkAttributes(new LinkAttributesBuilder().setMetric(new Metric(Long.valueOf(1L))).build()).build()).build());
        paBuilder.addAugmentation(PathAttributes1.class, (Augmentation)lsAttrBuilder.build());
        Assert.assertEquals((Object)lsAttrBuilder.build().getLinkstatePathAttribute(), (Object)((PathAttributes1)attrs.getAugmentation(PathAttributes1.class)).getLinkstatePathAttribute());
        List dests = ((DestinationLinkstateCase)mp.getAdvertizedRoutes().getDestinationType()).getDestinationLinkstate().getCLinkstateDestination();
        Assert.assertEquals((long)linkstates.size(), (long)dests.size());
        Assert.assertEquals((Object)linkstates, (Object)dests);
        builder.setPathAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(8), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testBGPNode() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(9), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(9), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        UpdateBuilder builder = new UpdateBuilder();
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("25.25.25.1")).build()).build();
        LocalNodeDescriptorsBuilder lndBuilder = new LocalNodeDescriptorsBuilder().setAsNumber(new AsNumber(Long.valueOf(100L))).setDomainId(new DomainIdentifier(Long.valueOf(0x19191901L))).setAreaId(new AreaIdentifier(Long.valueOf(0L)));
        CLinkstateDestinationBuilder clBuilder = new CLinkstateDestinationBuilder();
        clBuilder.setIdentifier(new Identifier(BigInteger.ONE));
        clBuilder.setNlriType(NlriType.Node);
        clBuilder.setProtocolId(ProtocolId.Ospf);
        ArrayList linkstates = Lists.newArrayList();
        clBuilder.setLocalNodeDescriptors(lndBuilder.setCRouterIdentifier((CRouterIdentifier)new OspfPseudonodeCaseBuilder().setOspfPseudonode(new OspfPseudonodeBuilder().setOspfRouterId(Long.valueOf(0x3030304L)).setLanInterface(new OspfInterfaceIdentifier(Long.valueOf(0xB0B0B03L))).build()).build()).build());
        linkstates.add(clBuilder.build());
        clBuilder.setLocalNodeDescriptors(lndBuilder.setCRouterIdentifier((CRouterIdentifier)new OspfNodeCaseBuilder().setOspfNode(new OspfNodeBuilder().setOspfRouterId(Long.valueOf(0x3030304L)).build()).build()).build());
        linkstates.add(clBuilder.build());
        clBuilder.setLocalNodeDescriptors(lndBuilder.setCRouterIdentifier((CRouterIdentifier)new OspfNodeCaseBuilder().setOspfNode(new OspfNodeBuilder().setOspfRouterId(Long.valueOf(0x1010102L)).build()).build()).build());
        linkstates.add(clBuilder.build());
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1Builder lsBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1Builder();
        MpReachNlriBuilder mpBuilder = new MpReachNlriBuilder();
        mpBuilder.setAfi(LinkstateAddressFamily.class);
        mpBuilder.setSafi(LinkstateSubsequentAddressFamily.class);
        mpBuilder.setCNextHop((CNextHop)nextHop);
        DestinationLinkstateBuilder dBuilder = new DestinationLinkstateBuilder();
        dBuilder.setCLinkstateDestination((List)linkstates);
        mpBuilder.setAdvertizedRoutes(new AdvertizedRoutesBuilder().setDestinationType((DestinationType)new DestinationLinkstateCaseBuilder().setDestinationLinkstate(dBuilder.build()).build()).build());
        lsBuilder.setMpReachNlri(mpBuilder.build());
        ArrayList asPath = Lists.newArrayList();
        PathAttributes attrs = message.getPathAttributes();
        PathAttributesBuilder paBuilder = new PathAttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments((List)asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setLocalPref(new LocalPrefBuilder().setPref(Long.valueOf(100L)).build());
        Assert.assertEquals((Object)paBuilder.getLocalPref(), (Object)attrs.getLocalPref());
        paBuilder.addAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1.class, (Augmentation)lsBuilder.build());
        MpReachNlri mp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1)attrs.getAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.PathAttributes1.class)).getMpReachNlri();
        Assert.assertEquals((Object)mpBuilder.getAfi(), (Object)mp.getAfi());
        Assert.assertEquals((Object)mpBuilder.getSafi(), (Object)mp.getSafi());
        Assert.assertEquals((Object)mpBuilder.getCNextHop(), (Object)mp.getCNextHop());
        List dests = ((DestinationLinkstateCase)mp.getAdvertizedRoutes().getDestinationType()).getDestinationLinkstate().getCLinkstateDestination();
        Assert.assertEquals((long)linkstates.size(), (long)dests.size());
        Assert.assertEquals((Object)linkstates, (Object)dests);
        builder.setPathAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(9), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testOpenMessage() throws Exception {
        MessageRegistry msgReg = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getMessageRegistry();
        Notification o = msgReg.parseMessage(Unpooled.copiedBuffer((byte[])inputBytes.get(13)));
        Open open = (Open)o;
        HashSet types = Sets.newHashSet();
        for (BgpParameters param : open.getBgpParameters()) {
            CParameters p = param.getCParameters();
            if (!(p instanceof MultiprotocolCase)) continue;
            BgpTableTypeImpl type = new BgpTableTypeImpl(((MultiprotocolCase)p).getMultiprotocolCapability().getAfi(), ((MultiprotocolCase)p).getMultiprotocolCapability().getSafi());
            types.add(type);
        }
        HashSet expected = Sets.newHashSet();
        expected.add(new BgpTableTypeImpl(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class));
        expected.add(new BgpTableTypeImpl(Ipv6AddressFamily.class, UnicastSubsequentAddressFamily.class));
        expected.add(new BgpTableTypeImpl(LinkstateAddressFamily.class, LinkstateSubsequentAddressFamily.class));
        Assert.assertEquals((Object)expected, (Object)types);
        ByteBuf buffer = Unpooled.buffer();
        msgReg.serializeMessage(o, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(13), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }
}

