/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunitiesParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.protocol.util.NoopReferenceCache;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.LinkstateAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.bgp.parameters.c.parameters.As4BytesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.bgp.parameters.c.parameters.As4BytesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.bgp.parameters.c.parameters.as4.bytes._case.As4BytesCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.MultiprotocolCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.MultiprotocolCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.multiprotocol._case.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.multiprotocol._case.MultiprotocolCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.AsSpecificExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.AsSpecificExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.Inet4SpecificExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.Inet4SpecificExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.OpaqueExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.OpaqueExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteOriginExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteOriginExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteTargetExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteTargetExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.as.specific.extended.community._case.AsSpecificExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.inet4.specific.extended.community._case.Inet4SpecificExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.opaque.extended.community._case.OpaqueExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.origin.extended.community._case.RouteOriginExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.target.extended.community._case.RouteTargetExtendedCommunityBuilder;

public class ComplementaryTest {
    private final ReferenceCache ref = NoopReferenceCache.getInstance();

    @Test
    public void testBGPParameter() {
        BgpTableTypeImpl t = new BgpTableTypeImpl(LinkstateAddressFamily.class, UnicastSubsequentAddressFamily.class);
        BgpTableTypeImpl t1 = new BgpTableTypeImpl(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class);
        MultiprotocolCapability cap = new MultiprotocolCapabilityBuilder().setAfi(LinkstateAddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build();
        MultiprotocolCase tlv1 = new MultiprotocolCaseBuilder().setMultiprotocolCapability(cap).build();
        MultiprotocolCapability cap1 = new MultiprotocolCapabilityBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build();
        MultiprotocolCase tlv2 = new MultiprotocolCaseBuilder().setMultiprotocolCapability(cap1).build();
        HashMap tt = Maps.newHashMap();
        tt.put(t, true);
        tt.put(t1, false);
        As4BytesCase tlv4 = new As4BytesCaseBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Long.valueOf(40L))).build()).build();
        Assert.assertFalse((boolean)tlv1.equals(tlv2));
        Assert.assertEquals((Object)cap.getSafi(), (Object)cap1.getSafi());
        Assert.assertNotSame((Object)cap.getAfi(), (Object)cap1.getAfi());
        Assert.assertEquals((long)40L, (long)tlv4.getAs4BytesCapability().getAsNumber().getValue());
        Assert.assertEquals((Object)new As4BytesCaseBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Long.valueOf(40L))).build()).build(), (Object)tlv4);
    }

    @Test
    public void testBGPAggregatorImpl() {
        Aggregator ipv4 = new AggregatorBuilder().setAsNumber(new AsNumber(Long.valueOf(5524L))).setNetworkAddress(new Ipv4Address("124.55.42.1")).build();
        Aggregator ipv4i = new AggregatorBuilder().setAsNumber(new AsNumber(Long.valueOf(5525L))).setNetworkAddress(new Ipv4Address("124.55.42.1")).build();
        Assert.assertNotSame((Object)ipv4.hashCode(), (Object)ipv4i.hashCode());
        Assert.assertNotSame((Object)ipv4.getAsNumber(), (Object)ipv4i.getAsNumber());
        Assert.assertEquals((Object)ipv4.getNetworkAddress(), (Object)ipv4i.getNetworkAddress());
    }

    @Test
    public void testCommunitiesParser() {
        ExtendedCommunities as = null;
        try {
            as = CommunitiesParser.parseExtendedCommunity((ReferenceCache)this.ref, (ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{0, 5, 0, 54, 0, 0, 1, 76}));
        }
        catch (BGPDocumentedException e1) {
            Assert.fail((String)("Not expected exception: " + (Object)((Object)e1)));
        }
        AsSpecificExtendedCommunityCase expected = new AsSpecificExtendedCommunityCaseBuilder().setAsSpecificExtendedCommunity(new AsSpecificExtendedCommunityBuilder().setTransitive(Boolean.valueOf(false)).setGlobalAdministrator(new ShortAsNumber(Long.valueOf(54L))).setLocalAdministrator(new byte[]{0, 0, 1, 76}).build()).build();
        AsSpecificExtendedCommunityCase result = (AsSpecificExtendedCommunityCase)as.getExtendedCommunity();
        Assert.assertEquals((Object)expected.getAsSpecificExtendedCommunity().isTransitive(), (Object)result.getAsSpecificExtendedCommunity().isTransitive());
        Assert.assertEquals((Object)expected.getAsSpecificExtendedCommunity().getGlobalAdministrator(), (Object)result.getAsSpecificExtendedCommunity().getGlobalAdministrator());
        Assert.assertArrayEquals((byte[])expected.getAsSpecificExtendedCommunity().getLocalAdministrator(), (byte[])result.getAsSpecificExtendedCommunity().getLocalAdministrator());
        Assert.assertEquals((long)0L, (long)as.getCommType().intValue());
        try {
            as = CommunitiesParser.parseExtendedCommunity((ReferenceCache)this.ref, (ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{40, 5, 0, 54, 0, 0, 1, 76}));
        }
        catch (BGPDocumentedException e1) {
            Assert.fail((String)("Not expected exception: " + (Object)((Object)e1)));
        }
        expected = new AsSpecificExtendedCommunityCaseBuilder().setAsSpecificExtendedCommunity(new AsSpecificExtendedCommunityBuilder().setTransitive(Boolean.valueOf(true)).setGlobalAdministrator(new ShortAsNumber(Long.valueOf(54L))).setLocalAdministrator(new byte[]{0, 0, 1, 76}).build()).build();
        result = (AsSpecificExtendedCommunityCase)as.getExtendedCommunity();
        Assert.assertEquals((Object)expected.getAsSpecificExtendedCommunity().isTransitive(), (Object)result.getAsSpecificExtendedCommunity().isTransitive());
        Assert.assertEquals((long)40L, (long)as.getCommType().intValue());
        ExtendedCommunities rtc = null;
        try {
            rtc = CommunitiesParser.parseExtendedCommunity((ReferenceCache)this.ref, (ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{1, 2, 0, 35, 4, 2, 8, 7}));
        }
        catch (BGPDocumentedException e1) {
            Assert.fail((String)("Not expected exception: " + (Object)((Object)e1)));
        }
        RouteTargetExtendedCommunityCase rexpected = new RouteTargetExtendedCommunityCaseBuilder().setRouteTargetExtendedCommunity(new RouteTargetExtendedCommunityBuilder().setGlobalAdministrator(new ShortAsNumber(Long.valueOf(35L))).setLocalAdministrator(new byte[]{4, 2, 8, 7}).build()).build();
        RouteTargetExtendedCommunityCase rresult = (RouteTargetExtendedCommunityCase)rtc.getExtendedCommunity();
        Assert.assertEquals((Object)rexpected.getRouteTargetExtendedCommunity().getGlobalAdministrator(), (Object)rresult.getRouteTargetExtendedCommunity().getGlobalAdministrator());
        Assert.assertArrayEquals((byte[])rexpected.getRouteTargetExtendedCommunity().getLocalAdministrator(), (byte[])rresult.getRouteTargetExtendedCommunity().getLocalAdministrator());
        Assert.assertEquals((long)1L, (long)rtc.getCommType().intValue());
        Assert.assertEquals((long)2L, (long)rtc.getCommSubType().intValue());
        ExtendedCommunities roc = null;
        try {
            roc = CommunitiesParser.parseExtendedCommunity((ReferenceCache)this.ref, (ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{0, 3, 0, 24, 4, 2, 8, 7}));
        }
        catch (BGPDocumentedException e1) {
            Assert.fail((String)("Not expected exception: " + (Object)((Object)e1)));
        }
        RouteOriginExtendedCommunityCase oexpected = new RouteOriginExtendedCommunityCaseBuilder().setRouteOriginExtendedCommunity(new RouteOriginExtendedCommunityBuilder().setGlobalAdministrator(new ShortAsNumber(Long.valueOf(24L))).setLocalAdministrator(new byte[]{4, 2, 8, 7}).build()).build();
        RouteOriginExtendedCommunityCase oresult = (RouteOriginExtendedCommunityCase)roc.getExtendedCommunity();
        Assert.assertEquals((Object)oexpected.getRouteOriginExtendedCommunity().getGlobalAdministrator(), (Object)oresult.getRouteOriginExtendedCommunity().getGlobalAdministrator());
        Assert.assertArrayEquals((byte[])oexpected.getRouteOriginExtendedCommunity().getLocalAdministrator(), (byte[])oresult.getRouteOriginExtendedCommunity().getLocalAdministrator());
        Assert.assertEquals((long)0L, (long)roc.getCommType().intValue());
        Assert.assertEquals((long)3L, (long)roc.getCommSubType().intValue());
        ExtendedCommunities sec = null;
        try {
            sec = CommunitiesParser.parseExtendedCommunity((ReferenceCache)this.ref, (ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{41, 6, 12, 51, 2, 5, 21, 45}));
        }
        catch (BGPDocumentedException e1) {
            Assert.fail((String)("Not expected exception: " + (Object)((Object)e1)));
        }
        Inet4SpecificExtendedCommunityCase iexpected = new Inet4SpecificExtendedCommunityCaseBuilder().setInet4SpecificExtendedCommunity(new Inet4SpecificExtendedCommunityBuilder().setTransitive(Boolean.valueOf(true)).setGlobalAdministrator(new Ipv4Address("12.51.2.5")).setLocalAdministrator(new byte[]{21, 45}).build()).build();
        Inet4SpecificExtendedCommunityCase iresult = (Inet4SpecificExtendedCommunityCase)sec.getExtendedCommunity();
        Assert.assertEquals((Object)iexpected.getInet4SpecificExtendedCommunity().isTransitive(), (Object)iresult.getInet4SpecificExtendedCommunity().isTransitive());
        Assert.assertEquals((Object)iexpected.getInet4SpecificExtendedCommunity().getGlobalAdministrator(), (Object)iresult.getInet4SpecificExtendedCommunity().getGlobalAdministrator());
        Assert.assertArrayEquals((byte[])iexpected.getInet4SpecificExtendedCommunity().getLocalAdministrator(), (byte[])iresult.getInet4SpecificExtendedCommunity().getLocalAdministrator());
        Assert.assertEquals((long)41L, (long)sec.getCommType().intValue());
        ExtendedCommunities oec = null;
        try {
            oec = CommunitiesParser.parseExtendedCommunity((ReferenceCache)this.ref, (ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{3, 6, 21, 45, 5, 4, 3, 1}));
        }
        catch (BGPDocumentedException e1) {
            Assert.fail((String)("Not expected exception: " + (Object)((Object)e1)));
        }
        OpaqueExtendedCommunityCase oeexpected = new OpaqueExtendedCommunityCaseBuilder().setOpaqueExtendedCommunity(new OpaqueExtendedCommunityBuilder().setTransitive(Boolean.valueOf(false)).setValue(new byte[]{21, 45, 5, 4, 3, 1}).build()).build();
        OpaqueExtendedCommunityCase oeresult = (OpaqueExtendedCommunityCase)oec.getExtendedCommunity();
        Assert.assertEquals((Object)oeexpected.getOpaqueExtendedCommunity().isTransitive(), (Object)oeresult.getOpaqueExtendedCommunity().isTransitive());
        Assert.assertArrayEquals((byte[])oeexpected.getOpaqueExtendedCommunity().getValue(), (byte[])oeresult.getOpaqueExtendedCommunity().getValue());
        Assert.assertEquals((long)3L, (long)oec.getCommType().intValue());
        try {
            oec = CommunitiesParser.parseExtendedCommunity((ReferenceCache)this.ref, (ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{43, 6, 21, 45, 5, 4, 3, 1}));
        }
        catch (BGPDocumentedException e1) {
            Assert.fail((String)("Not expected exception: " + (Object)((Object)e1)));
        }
        OpaqueExtendedCommunityCase oeexpected1 = new OpaqueExtendedCommunityCaseBuilder().setOpaqueExtendedCommunity(new OpaqueExtendedCommunityBuilder().setTransitive(Boolean.valueOf(true)).setValue(new byte[]{21, 45, 5, 4, 3, 1}).build()).build();
        OpaqueExtendedCommunityCase oeresult1 = (OpaqueExtendedCommunityCase)oec.getExtendedCommunity();
        Assert.assertEquals((Object)oeexpected1.getOpaqueExtendedCommunity().isTransitive(), (Object)oeresult1.getOpaqueExtendedCommunity().isTransitive());
        Assert.assertArrayEquals((byte[])oeexpected1.getOpaqueExtendedCommunity().getValue(), (byte[])oeresult1.getOpaqueExtendedCommunity().getValue());
        Assert.assertEquals((long)43L, (long)oec.getCommType().intValue());
        try {
            CommunitiesParser.parseExtendedCommunity((ReferenceCache)this.ref, (ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{11, 11, 21, 45, 5, 4, 3, 1}));
            Assert.fail((String)"Exception should have occured.");
        }
        catch (BGPDocumentedException e) {
            Assert.assertEquals((Object)"Could not parse Extended Community type: 11", (Object)e.getMessage());
        }
    }

    @Test
    public void testBGPHeaderParser() throws Exception {
        MessageRegistry msgReg = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getMessageRegistry();
        try {
            msgReg.parseMessage(Unpooled.copiedBuffer((byte[])new byte[]{0, 0}));
            Assert.fail((String)"Exception should have occured.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Too few bytes in passed array. Passed: 2. Expected: >= 19.", (Object)e.getMessage());
        }
    }

    @Test
    public void testMessageParser() throws Exception {
        MessageRegistry msgReg = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getMessageRegistry();
        String ex = "";
        try {
            msgReg.serializeMessage(null, Unpooled.EMPTY_BUFFER);
        }
        catch (NullPointerException e) {
            ex = e.getMessage();
        }
        Assert.assertEquals((Object)"BGPMessage is mandatory.", (Object)ex);
    }
}

