/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.LinkstateAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.linkstate.rev131125.LinkstateSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.KeepaliveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Notify;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.NotifyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.BgpParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.bgp.parameters.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.MultiprotocolCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.c.parameters.multiprotocol._case.MultiprotocolCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Notification;

public class ParserTest {
    private static final byte[] openBMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 29, 1, 4, 0, 100, 0, -76, 20, 20, 20, 20, 0};
    private static final byte[] keepAliveBMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 4};
    private static final byte[] notificationBMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 23, 3, 2, 4, 4, 9};
    private static final byte[] openWithCpblt1 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 45, 1, 4, 0, 72, 0, -76, -84, 20, -96, -86, 16, 2, 6, 1, 4, 0, 1, 0, 1, 2, 6, 1, 4, 64, 4, 0, 71};
    private static final byte[] openWithCpblt2 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 45, 1, 4, 0, 72, 0, -76, -84, 20, -96, -86, 16, 2, 6, 1, 4, 64, 4, 0, 71, 2, 6, 1, 4, 0, 1, 0, 1};
    private static final byte[] updMsgWithUnrecognizedAttribute = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 121, 2, 0, 0, 0, 98, -112, 14, 0, 52, 64, 4, 71, 4, 10, 25, 2, 27, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 0, 72, 2, 1, 0, 4, 40, 40, 40, 40, 2, 3, 0, 6, 0, 0, 0, 0, 0, 67, 64, 1, 1, 0, 64, 2, 0, 64, 5, 4, 0, 0, 0, 100, -128, 99, 25, 4, 2, 0, 8, 79, 102, 45, 57, 107, 45, 48, 51, 4, 3, 0, 1, 114, 4, 4, 0, 4, 43, 43, 43, 43};
    static MessageRegistry reg;

    @BeforeClass
    public static void setupClass() throws Exception {
        reg = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getMessageRegistry();
    }

    @Test
    public void testHeaderErrors() throws BGPParsingException, BGPDocumentedException {
        byte[] wrong = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0};
        wrong = ByteArray.cutBytes((byte[])wrong, (int)16);
        try {
            reg.parseMessage(Unpooled.copiedBuffer((byte[])wrong));
            Assert.fail((String)"Exception should have occcured.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)("Too few bytes in passed array. Passed: " + wrong.length + ". Expected: >= 19."), (Object)e.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testBadMsgType() throws BGPParsingException {
        byte[] bytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 8};
        try {
            reg.parseMessage(Unpooled.copiedBuffer((byte[])bytes));
            Assert.fail((String)"Exception should have occured.");
        }
        catch (BGPDocumentedException e) {
            Assert.assertEquals((Object)BGPError.BAD_MSG_TYPE, (Object)e.getError());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testKeepAliveMsg() throws BGPParsingException, BGPDocumentedException {
        Keepalive keepAlive = new KeepaliveBuilder().build();
        ByteBuf buffer = Unpooled.buffer();
        reg.serializeMessage((Notification)keepAlive, buffer);
        Assert.assertArrayEquals((byte[])keepAliveBMsg, (byte[])ByteArray.getAllBytes((ByteBuf)buffer));
        Notification m = reg.parseMessage(Unpooled.copiedBuffer((byte[])ByteArray.getAllBytes((ByteBuf)buffer)));
        Assert.assertTrue((boolean)(m instanceof Keepalive));
    }

    @Test
    public void testBadKeepAliveMsg() throws BGPParsingException {
        byte[] bytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 20, 4, 5};
        try {
            reg.parseMessage(Unpooled.copiedBuffer((byte[])bytes));
            Assert.fail((String)"Exception should have occured.");
        }
        catch (BGPDocumentedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)JUnitMatchers.containsString((String)"Message length field not within valid range."));
            Assert.assertEquals((Object)BGPError.BAD_MSG_LENGTH, (Object)e.getError());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testOpenMessage() throws UnknownHostException, BGPParsingException, BGPDocumentedException {
        Open open = new OpenBuilder().setMyAsNumber(Integer.valueOf(100)).setHoldTimer(Integer.valueOf(180)).setBgpIdentifier(new Ipv4Address("20.20.20.20")).setVersion(new ProtocolVersion(Short.valueOf((short)4))).build();
        ByteBuf bytes = Unpooled.buffer();
        reg.serializeMessage((Notification)open, bytes);
        Assert.assertArrayEquals((byte[])openBMsg, (byte[])ByteArray.getAllBytes((ByteBuf)bytes));
        Notification m = reg.parseMessage(Unpooled.copiedBuffer((ByteBuf)bytes));
        Assert.assertTrue((boolean)(m instanceof Open));
        Assert.assertEquals((long)100L, (long)((Open)m).getMyAsNumber().intValue());
        Assert.assertEquals((long)180L, (long)((Open)m).getHoldTimer().intValue());
        Assert.assertEquals((Object)new Ipv4Address("20.20.20.20"), (Object)((Open)m).getBgpIdentifier());
        Assert.assertTrue((boolean)((Open)m).getBgpParameters().isEmpty());
    }

    @Test
    public void testBadHoldTimeError() throws BGPParsingException {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 29, 1, 4, 0, 100, 0, 1, 20, 20, 20, 20, 0};
        try {
            reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg));
            Assert.fail((String)"Exception should have occured.");
        }
        catch (BGPDocumentedException e) {
            Assert.assertEquals((Object)"Hold time value not acceptable.", (Object)e.getMessage());
            Assert.assertEquals((Object)BGPError.HOLD_TIME_NOT_ACC, (Object)e.getError());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testBadMsgLength() throws BGPParsingException {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 27, 1, 4, 0, 100, 0, -76, -1, -1, -1};
        try {
            reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg));
            Assert.fail((String)"Exception should have occured.");
        }
        catch (BGPDocumentedException e) {
            Assert.assertEquals((Object)"Open message too small.", (Object)e.getMessage());
            Assert.assertEquals((Object)BGPError.BAD_MSG_LENGTH, (Object)e.getError());
        }
    }

    @Test
    public void testBadVersion() throws BGPParsingException {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 29, 1, 8, 0, 100, 0, -76, 20, 20, 20, 20, 0};
        try {
            reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg));
            Assert.fail((String)"Exception should have occured.");
        }
        catch (BGPDocumentedException e) {
            Assert.assertEquals((Object)"BGP Protocol version 8 not supported.", (Object)e.getMessage());
            Assert.assertEquals((Object)BGPError.VERSION_NOT_SUPPORTED, (Object)e.getError());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testNotificationMsg() throws BGPParsingException, BGPDocumentedException {
        Notify notMsg = new NotifyBuilder().setErrorCode(Short.valueOf(BGPError.OPT_PARAM_NOT_SUPPORTED.getCode())).setErrorSubcode(Short.valueOf(BGPError.OPT_PARAM_NOT_SUPPORTED.getSubcode())).setData(new byte[]{4, 9}).build();
        ByteBuf bytes = Unpooled.buffer();
        reg.serializeMessage((Notification)notMsg, bytes);
        Assert.assertArrayEquals((byte[])notificationBMsg, (byte[])ByteArray.subByte((byte[])bytes.array(), (int)0, (int)bytes.writerIndex()));
        Notification m = reg.parseMessage(Unpooled.copiedBuffer((ByteBuf)bytes));
        Assert.assertTrue((boolean)(m instanceof Notify));
        Assert.assertEquals((Object)BGPError.OPT_PARAM_NOT_SUPPORTED, (Object)BGPError.forValue((int)((Notify)m).getErrorCode().shortValue(), (int)((Notify)m).getErrorSubcode().shortValue()));
        Assert.assertArrayEquals((byte[])new byte[]{4, 9}, (byte[])((Notify)m).getData());
        notMsg = new NotifyBuilder().setErrorCode(Short.valueOf(BGPError.CONNECTION_NOT_SYNC.getCode())).setErrorSubcode(Short.valueOf(BGPError.CONNECTION_NOT_SYNC.getSubcode())).build();
        bytes.clear();
        reg.serializeMessage((Notification)notMsg, bytes);
        m = reg.parseMessage(Unpooled.copiedBuffer((ByteBuf)bytes));
        Assert.assertTrue((boolean)(m instanceof Notify));
        Assert.assertEquals((Object)BGPError.CONNECTION_NOT_SYNC, (Object)BGPError.forValue((int)((Notify)m).getErrorCode().shortValue(), (int)((Notify)m).getErrorSubcode().shortValue()));
        Assert.assertNull((Object)((Notify)m).getData());
    }

    @Test
    public void testWrongLength() throws BGPParsingException {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 20, 3, 2};
        try {
            reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg));
            Assert.fail((String)"Exception should have occured.");
        }
        catch (BGPDocumentedException e) {
            Assert.assertEquals((Object)"Notification message too small.", (Object)e.getMessage());
            Assert.assertEquals((Object)BGPError.BAD_MSG_LENGTH, (Object)e.getError());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testUnrecognizedError() throws BGPParsingException, BGPDocumentedException {
        byte[] bMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 21, 3, 2, -86};
        try {
            reg.parseMessage(Unpooled.copiedBuffer((byte[])bMsg));
            Assert.fail((String)"Exception should have occured.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"BGP Error code 2 and subcode 170 not recognized.", (Object)e.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testTLVParser() throws UnknownHostException {
        BgpTableTypeImpl t1 = new BgpTableTypeImpl(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class);
        BgpTableTypeImpl t2 = new BgpTableTypeImpl(LinkstateAddressFamily.class, UnicastSubsequentAddressFamily.class);
        ArrayList tlvs = Lists.newArrayList();
        tlvs.add(new BgpParametersBuilder().setCParameters((CParameters)new MultiprotocolCaseBuilder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder().setAfi(LinkstateAddressFamily.class).setSafi(LinkstateSubsequentAddressFamily.class).build()).build()).build());
        tlvs.add(new BgpParametersBuilder().setCParameters((CParameters)new MultiprotocolCaseBuilder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build()).build()).build());
        HashMap tableTypes = Maps.newHashMap();
        tableTypes.put(t1, true);
        tableTypes.put(t2, true);
        Open open = new OpenBuilder().setMyAsNumber(Integer.valueOf(72)).setHoldTimer(Integer.valueOf(180)).setBgpIdentifier(new Ipv4Address("172.20.160.170")).setVersion(new ProtocolVersion(Short.valueOf((short)4))).setBgpParameters((List)tlvs).build();
        ByteBuf result = Unpooled.buffer();
        reg.serializeMessage((Notification)open, result);
        Assert.assertTrue((Arrays.equals(openWithCpblt1, ByteArray.getAllBytes((ByteBuf)result)) || Arrays.equals(openWithCpblt2, ByteArray.getAllBytes((ByteBuf)result)) ? 1 : 0) != 0);
    }

    @Test
    public void testParseUpdMsgWithUnrecognizedAttribute() throws BGPDocumentedException, BGPParsingException {
        Update updMsg = (Update)reg.parseMessage(Unpooled.copiedBuffer((byte[])updMsgWithUnrecognizedAttribute));
        Assert.assertNotNull((Object)updMsg.getPathAttributes());
    }
}

