/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.target.extended.community._case.RouteTargetExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.target.extended.community._case.RouteTargetExtendedCommunityBuilder;

public class RouteTargetCommunityTest {
    private RouteTargetExtendedCommunity community;

    @Before
    public void init() {
        ShortAsNumber globalAdmin = new ShortAsNumber(Long.valueOf(65535L));
        byte[] localAdmin = new byte[]{10, 0, 0, 1};
        this.community = new RouteTargetExtendedCommunityBuilder().setGlobalAdministrator(globalAdmin).setLocalAdministrator(localAdmin).build();
    }

    @Test
    public void testGetGlobalAdmin() {
        ShortAsNumber testAsn = new ShortAsNumber(Long.valueOf(65535L));
        Assert.assertEquals((Object)this.community.getGlobalAdministrator(), (Object)testAsn);
    }

    @Test
    public void testGetLocalAdmin() {
        Assert.assertArrayEquals((byte[])new byte[]{10, 0, 0, 1}, (byte[])this.community.getLocalAdministrator());
    }
}

