/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPUpdateMessageParser;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.NoopReferenceCache;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.ipv6.prefixes.DestinationIpv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.ipv6.prefixes.destination.ipv6.Ipv6Prefixes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.ipv6.prefixes.destination.ipv6.Ipv6PrefixesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.update.attributes.mp.reach.nlri.advertized.routes.destination.type.DestinationIpv6CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.UpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.AtomicAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.LocalPrefBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.MultiExitDiscBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.OriginBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.OriginatorIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.as.path.SegmentsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.message.NlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.message.WithdrawnRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.Attributes1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.Attributes1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.Attributes2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.destination.DestinationType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.mp.reach.nlri.AdvertizedRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.BgpOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ClusterIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteTargetIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.target.ipv4._case.RouteTargetIpv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv4NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv6NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv6NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.ipv6.next.hop._case.Ipv6NextHopBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.Notification;

public class BGPParserTest {
    static final List<byte[]> inputBytes = new ArrayList<byte[]>();
    private static int COUNTER = 7;
    private static int MAX_SIZE = 300;
    private static BGPUpdateMessageParser updateParser;
    private static final int LENGTH_FIELD_LENGTH = 2;

    @BeforeClass
    public static void setUp() throws Exception {
        updateParser = new BGPUpdateMessageParser(ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getAttributeRegistry());
        for (int i = 1; i <= COUNTER; ++i) {
            String name = "/up" + i + ".bin";
            try (InputStream is = BGPParserTest.class.getResourceAsStream(name);){
                if (is == null) {
                    throw new IOException("Failed to get resource " + name);
                }
                ByteArrayOutputStream bis = new ByteArrayOutputStream();
                byte[] data = new byte[MAX_SIZE];
                int nRead = 0;
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    bis.write(data, 0, nRead);
                }
                bis.flush();
                inputBytes.add(bis.toByteArray());
                is.close();
                continue;
            }
        }
    }

    @Test
    public void testResource() {
        Assert.assertNotNull(inputBytes);
    }

    @Test
    public void testGetUpdateMessage1() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(0), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(0), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        ArrayList<AsNumber> asNumbers = new ArrayList<AsNumber>();
        asNumbers.add(new AsNumber(Long.valueOf(65002L)));
        ArrayList asPath = Lists.newArrayList();
        asPath.add(new SegmentsBuilder().setAsSequence(asNumbers).build());
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("10.0.0.2")).build()).build();
        ArrayList comms = Lists.newArrayList();
        comms.add((Communities)CommunityUtil.NO_EXPORT);
        comms.add((Communities)CommunityUtil.NO_ADVERTISE);
        comms.add((Communities)CommunityUtil.NO_EXPORT_SUBCONFED);
        comms.add((Communities)CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), (long)65535L, (int)65296));
        UpdateBuilder builder = new UpdateBuilder();
        ArrayList prefs = Lists.newArrayList();
        prefs.add(new Ipv4Prefix("172.17.2.0/24"));
        prefs.add(new Ipv4Prefix("172.17.1.0/24"));
        prefs.add(new Ipv4Prefix("172.17.0.0/24"));
        Nlri nlri = new NlriBuilder().setNlri((List)prefs).build();
        Assert.assertEquals((Object)nlri, (Object)message.getNlri());
        builder.setNlri(nlri);
        Attributes attrs = message.getAttributes();
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments((List)asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Long.valueOf(0L)).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setAtomicAggregate(new AtomicAggregateBuilder().build());
        Assert.assertEquals((Object)paBuilder.getAtomicAggregate(), (Object)attrs.getAtomicAggregate());
        paBuilder.setCommunities((List)comms);
        Assert.assertEquals((Object)paBuilder.getCommunities(), (Object)attrs.getCommunities());
        paBuilder.setUnrecognizedAttributes(Collections.emptyList());
        builder.setAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(0), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage2() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(1), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(1), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        UpdateBuilder builder = new UpdateBuilder();
        ArrayList<Ipv6Prefixes> prefs = new ArrayList<Ipv6Prefixes>();
        prefs.add(new Ipv6PrefixesBuilder().setPrefix(new Ipv6Prefix("2001:db8:1:2::/64")).build());
        prefs.add(new Ipv6PrefixesBuilder().setPrefix(new Ipv6Prefix("2001:db8:1:1::/64")).build());
        prefs.add(new Ipv6PrefixesBuilder().setPrefix(new Ipv6Prefix("2001:db8:1::/64")).build());
        Assert.assertNull((Object)message.getNlri());
        ArrayList<AsNumber> asNumbers = new ArrayList<AsNumber>();
        asNumbers.add(new AsNumber(Long.valueOf(65001L)));
        ArrayList asPath = Lists.newArrayList();
        asPath.add(new SegmentsBuilder().setAsSequence(asNumbers).build());
        Ipv6NextHopCase nextHop = new Ipv6NextHopCaseBuilder().setIpv6NextHop(new Ipv6NextHopBuilder().setGlobal(new Ipv6Address("2001:db8::1")).setLinkLocal(new Ipv6Address("fe80::c001:bff:fe7e:0")).build()).build();
        ArrayList clusters = Lists.newArrayList((Object[])new ClusterIdentifier[]{new ClusterIdentifier(new Ipv4Address("1.2.3.4")), new ClusterIdentifier(new Ipv4Address("5.6.7.8"))});
        Attributes attrs = message.getAttributes();
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Igp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments((List)asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Long.valueOf(0L)).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setOriginatorId(new OriginatorIdBuilder().setOriginator(new Ipv4Address("127.0.0.1")).build());
        Assert.assertEquals((Object)paBuilder.getOriginatorId(), (Object)attrs.getOriginatorId());
        paBuilder.setClusterId(new ClusterIdBuilder().setCluster((List)clusters).build());
        Assert.assertEquals((Object)paBuilder.getClusterId(), (Object)attrs.getClusterId());
        MpReachNlriBuilder mpBuilder = new MpReachNlriBuilder();
        mpBuilder.setAfi(Ipv6AddressFamily.class);
        mpBuilder.setSafi(UnicastSubsequentAddressFamily.class);
        mpBuilder.setCNextHop((CNextHop)nextHop);
        mpBuilder.setAdvertizedRoutes(new AdvertizedRoutesBuilder().setDestinationType((DestinationType)new DestinationIpv6CaseBuilder().setDestinationIpv6(new DestinationIpv6Builder().setIpv6Prefixes(prefs).build()).build()).build());
        paBuilder.addAugmentation(Attributes1.class, (Augmentation)new Attributes1Builder().setMpReachNlri(mpBuilder.build()).build());
        Assert.assertEquals((Object)((Attributes1)paBuilder.getAugmentation(Attributes1.class)).getMpReachNlri(), (Object)((Attributes1)attrs.getAugmentation(Attributes1.class)).getMpReachNlri());
        paBuilder.setUnrecognizedAttributes(Collections.emptyList());
        builder.setAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(1), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage3() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(2), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(2), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        UpdateBuilder builder = new UpdateBuilder();
        Ipv4Prefix pref1 = new Ipv4Prefix("172.16.0.0/21");
        ArrayList nlri = Lists.newArrayList((Object[])new Ipv4Prefix[]{pref1});
        builder.setNlri(new NlriBuilder().setNlri((List)nlri).build());
        Assert.assertEquals((Object)builder.getNlri(), (Object)message.getNlri());
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        ArrayList<AsNumber> asNumbers = new ArrayList<AsNumber>();
        asNumbers.add(new AsNumber(Long.valueOf(30L)));
        ArrayList asPath = Lists.newArrayList();
        asPath.add(new SegmentsBuilder().setAsSequence(asNumbers).build());
        ArrayList asSet = Lists.newArrayList((Object[])new AsNumber[]{new AsNumber(Long.valueOf(10L)), new AsNumber(Long.valueOf(20L))});
        asPath.add(new SegmentsBuilder().setAsSet((List)asSet).build());
        Aggregator aggregator = new AggregatorBuilder().setAsNumber(new AsNumber(Long.valueOf(30L))).setNetworkAddress(new Ipv4Address("10.0.0.9")).build();
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("10.0.0.9")).build()).build();
        Attributes attrs = message.getAttributes();
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Incomplete).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments((List)asPath).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Long.valueOf(0L)).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setAggregator(aggregator);
        Assert.assertEquals((Object)paBuilder.getAggregator(), (Object)attrs.getAggregator());
        paBuilder.setUnrecognizedAttributes(Collections.emptyList());
        builder.setAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(2), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage4() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(3), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(3), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        UpdateBuilder builder = new UpdateBuilder();
        Assert.assertNull((Object)message.getWithdrawnRoutes());
        Ipv4Prefix pref1 = new Ipv4Prefix("10.30.3.0/24");
        Ipv4Prefix pref2 = new Ipv4Prefix("10.30.2.0/24");
        Ipv4Prefix pref3 = new Ipv4Prefix("10.30.1.0/24");
        ArrayList nlri = Lists.newArrayList((Object[])new Ipv4Prefix[]{pref1, pref2, pref3});
        builder.setNlri(new NlriBuilder().setNlri((List)nlri).build());
        Assert.assertEquals((Object)builder.getNlri(), (Object)message.getNlri());
        Ipv4NextHopCase nextHop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("3.3.3.3")).build()).build();
        ArrayList comms = Lists.newArrayList();
        comms.add(new ExtendedCommunitiesBuilder().setTransitive(Boolean.valueOf(true)).setExtendedCommunity((ExtendedCommunity)new RouteTargetIpv4CaseBuilder().setRouteTargetIpv4(new RouteTargetIpv4Builder().setGlobalAdministrator(new Ipv4Address("192.168.1.0")).setLocalAdministrator(Integer.valueOf(4660)).build()).build()).build());
        Attributes attrs = message.getAttributes();
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setOrigin(new OriginBuilder().setValue(BgpOrigin.Egp).build());
        Assert.assertEquals((Object)paBuilder.getOrigin(), (Object)attrs.getOrigin());
        paBuilder.setAsPath(new AsPathBuilder().setSegments(Collections.emptyList()).build());
        Assert.assertEquals((Object)paBuilder.getAsPath(), (Object)attrs.getAsPath());
        paBuilder.setCNextHop((CNextHop)nextHop);
        Assert.assertEquals((Object)paBuilder.getCNextHop(), (Object)attrs.getCNextHop());
        paBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Long.valueOf(0L)).build());
        Assert.assertEquals((Object)paBuilder.getMultiExitDisc(), (Object)attrs.getMultiExitDisc());
        paBuilder.setLocalPref(new LocalPrefBuilder().setPref(Long.valueOf(100L)).build());
        Assert.assertEquals((Object)paBuilder.getLocalPref(), (Object)attrs.getLocalPref());
        paBuilder.setExtendedCommunities((List)comms);
        Assert.assertEquals((Object)paBuilder.getExtendedCommunities(), (Object)attrs.getExtendedCommunities());
        paBuilder.setUnrecognizedAttributes(Collections.emptyList());
        builder.setAttributes(paBuilder.build());
        Assert.assertEquals((Object)builder.build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(3), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testGetUpdateMessage5() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(4), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(4), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        ArrayList prefs = Lists.newArrayList((Object[])new Ipv4Prefix[]{new Ipv4Prefix("172.16.0.4/30")});
        Update expectedMessage = new UpdateBuilder().setWithdrawnRoutes(new WithdrawnRoutesBuilder().setWithdrawnRoutes((List)prefs).build()).build();
        Assert.assertEquals((Object)expectedMessage.getWithdrawnRoutes(), (Object)message.getWithdrawnRoutes());
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(4), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testEORIpv4() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(5), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(5), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Assert.assertEquals((Object)new UpdateBuilder().build(), (Object)message);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(5), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testEORIpv6() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(6), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(6), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Class afi = ((Attributes2)message.getAttributes().getAugmentation(Attributes2.class)).getMpUnreachNlri().getAfi();
        Class safi = ((Attributes2)message.getAttributes().getAugmentation(Attributes2.class)).getMpUnreachNlri().getSafi();
        Assert.assertEquals(Ipv6AddressFamily.class, (Object)afi);
        Assert.assertEquals(UnicastSubsequentAddressFamily.class, (Object)safi);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(6), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testEORIpv6exLength() throws Exception {
        byte[] body = ByteArray.cutBytes((byte[])inputBytes.get(6), (int)19);
        int messageLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])inputBytes.get(6), (int)16, (int)2));
        Update message = updateParser.parseMessageBody(Unpooled.copiedBuffer((byte[])body), messageLength);
        Class afi = ((Attributes2)message.getAttributes().getAugmentation(Attributes2.class)).getMpUnreachNlri().getAfi();
        Class safi = ((Attributes2)message.getAttributes().getAugmentation(Attributes2.class)).getMpUnreachNlri().getSafi();
        Assert.assertEquals(Ipv6AddressFamily.class, (Object)afi);
        Assert.assertEquals(UnicastSubsequentAddressFamily.class, (Object)safi);
        ByteBuf buffer = Unpooled.buffer();
        updateParser.serializeMessage((Notification)message, buffer);
        Assert.assertArrayEquals((byte[])inputBytes.get(6), (byte[])ByteArray.readAllBytes((ByteBuf)buffer));
    }
}

