/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.protocol.util.NoopReferenceCache;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Community;

public class CommunityTest {
    final CommunityUtil util = new CommunityUtil((ReferenceCache)NoopReferenceCache.getInstance());

    @Test
    public void testCommunity() {
        this.util.create(10L, 222);
        Community c = this.util.create(12L, 12);
        Assert.assertEquals((long)12L, (long)c.getAsNumber().getValue().intValue());
        Assert.assertEquals((long)12L, (long)c.getSemantics().intValue());
    }

    @Test
    public void testOverflows() {
        try {
            this.util.create(10L, -2);
            Assert.fail((String)"Semantics under range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid range: -2, expected: [[0\u202565535]].", (Object)e.getMessage());
        }
        try {
            this.util.create(10L, 65536);
            Assert.fail((String)"Semantics above range.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid range: 65536, expected: [[0\u202565535]].", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        Community c = this.util.create(10L, 222);
        Assert.assertNotNull((Object)c.toString());
    }

    @Test
    public void testValueOf() {
        Community comm = this.util.valueOf("12:50");
        Assert.assertEquals((long)12L, (long)comm.getAsNumber().getValue().intValue());
        Assert.assertEquals((long)50L, (long)comm.getSemantics().intValue());
    }
}

